"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesLinkItems = void 0;
var _common = require("@kbn/cases-plugin/common");
var _public = require("@kbn/cases-plugin/public");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesLinkItems = () => {
  const casesLinks = (0, _public.getCasesDeepLinks)({
    basePath: _constants.CASES_PATH,
    extend: {
      [_constants.SecurityPageName.case]: {
        globalNavPosition: 5,
        capabilities: [`${_constants.CASES_FEATURE_ID}.${_common.READ_CASES_CAPABILITY}`]
      },
      [_constants.SecurityPageName.caseConfigure]: {
        capabilities: [`${_constants.CASES_FEATURE_ID}.${_common.UPDATE_CASES_CAPABILITY}`],
        licenseType: 'gold',
        sideNavDisabled: true
      },
      [_constants.SecurityPageName.caseCreate]: {
        capabilities: [`${_constants.CASES_FEATURE_ID}.${_common.CREATE_CASES_CAPABILITY}`],
        sideNavDisabled: true
      }
    }
  });
  const {
    id,
    deepLinks,
    ...rest
  } = casesLinks;
  return {
    ...rest,
    id: _constants.SecurityPageName.case,
    links: deepLinks
  };
};
exports.getCasesLinkItems = getCasesLinkItems;