"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnonymizationStore = void 0;
var _local_storage = require("../../common/components/local_storage");
var _anonymization = require("../content/anonymization");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ALLOW_KEY = `${_helpers.LOCAL_STORAGE_KEY}.defaultAllow`;
const DEFAULT_ALLOW_REPLACEMENT_KEY = `${_helpers.LOCAL_STORAGE_KEY}.defaultAllowReplacement`;
const useAnonymizationStore = () => {
  const [defaultAllow, setDefaultAllow] = (0, _local_storage.useLocalStorage)({
    defaultValue: _anonymization.DEFAULT_ALLOW,
    key: DEFAULT_ALLOW_KEY,
    isInvalidDefault: valueFromStorage => !Array.isArray(valueFromStorage)
  });
  const [defaultAllowReplacement, setDefaultAllowReplacement] = (0, _local_storage.useLocalStorage)({
    defaultValue: _anonymization.DEFAULT_ALLOW_REPLACEMENT,
    key: DEFAULT_ALLOW_REPLACEMENT_KEY,
    isInvalidDefault: valueFromStorage => !Array.isArray(valueFromStorage)
  });
  return {
    defaultAllow,
    defaultAllowReplacement,
    setDefaultAllow,
    setDefaultAllowReplacement
  };
};
exports.useAnonymizationStore = useAnonymizationStore;