"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _top_n = require("../../common/components/top_n");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _sourcerer = require("../../common/containers/sourcerer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopNAction = ({
  onClose,
  context,
  casesService
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const CasesContext = casesService.ui.getCasesContext();
  const {
    field,
    nodeRef,
    metadata
  } = context;
  if (!(nodeRef !== null && nodeRef !== void 0 && nodeRef.current)) return null;
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    button: nodeRef.current,
    isOpen: true,
    closePopover: onClose,
    anchorPosition: 'downCenter',
    hasArrow: false,
    repositionOnScroll: true,
    ownFocus: true,
    attachToAnchor: false
  }, /*#__PURE__*/_react.default.createElement(_top_n.StatefulTopN, {
    field: field.name,
    showLegend: true,
    scopeId: metadata === null || metadata === void 0 ? void 0 : metadata.scopeId,
    toggleTopN: onClose,
    value: field.value,
    indexPattern: indexPattern,
    browserFields: browserFields
  })));
};
exports.TopNAction = TopNAction;