"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToTimelineCellActionFactory = void 0;
var _cellActions = require("@kbn/cell-actions");
var _actions = require("../../../timelines/store/timeline/actions");
var _types = require("../../../../common/types");
var _utils = require("../../utils");
var _constants = require("../constants");
var _data_provider = require("../data_provider");
var _constants2 = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAddToTimelineCellActionFactory = (0, _cellActions.createCellActionFactory)(({
  store,
  services
}) => {
  const {
    notifications: notificationsService
  } = services;
  return {
    type: _constants2.SecurityCellActionType.ADD_TO_TIMELINE,
    getIconType: () => _constants.ADD_TO_TIMELINE_ICON,
    getDisplayName: () => _constants.ADD_TO_TIMELINE,
    getDisplayNameTooltip: () => _constants.ADD_TO_TIMELINE,
    isCompatible: async ({
      field
    }) => (0, _utils.fieldHasCellActions)(field.name) && (0, _data_provider.isValidDataProviderField)(field.name, field.type),
    execute: async ({
      field: {
        value,
        type,
        name
      },
      metadata
    }) => {
      var _createDataProviders;
      const values = Array.isArray(value) ? value : [value];
      const [firstValue, ...andValues] = values;
      const [dataProvider] = (_createDataProviders = (0, _data_provider.createDataProviders)({
        contextId: _types.TimelineId.active,
        fieldType: type,
        values: firstValue,
        field: name,
        negate: (metadata === null || metadata === void 0 ? void 0 : metadata.negateFilters) === true
      })) !== null && _createDataProviders !== void 0 ? _createDataProviders : [];
      if (dataProvider) {
        andValues.forEach(andValue => {
          var _createDataProviders2;
          const [andDataProvider] = (_createDataProviders2 = (0, _data_provider.createDataProviders)({
            contextId: _types.TimelineId.active,
            fieldType: type,
            values: andValue,
            field: name,
            negate: (metadata === null || metadata === void 0 ? void 0 : metadata.negateFilters) === true
          })) !== null && _createDataProviders2 !== void 0 ? _createDataProviders2 : [];
          if (andDataProvider) {
            dataProvider.and.push(andDataProvider);
          }
        });
      }
      if (dataProvider) {
        store.dispatch((0, _actions.addProvider)({
          id: _types.TimelineId.active,
          providers: [dataProvider]
        }));
        let messageValue = '';
        if (value != null) {
          messageValue = Array.isArray(value) ? value.join(', ') : value;
        }
        notificationsService.toasts.addSuccess({
          title: (0, _constants.ADD_TO_TIMELINE_SUCCESS_TITLE)(messageValue)
        });
      } else {
        notificationsService.toasts.addWarning({
          title: _constants.ADD_TO_TIMELINE_FAILED_TITLE,
          text: _constants.ADD_TO_TIMELINE_FAILED_TEXT
        });
      }
    }
  };
});
exports.createAddToTimelineCellActionFactory = createAddToTimelineCellActionFactory;