"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectTimelineTypeLiteralWithNullRt = exports.SavedObjectTimelineType = exports.SavedObjectTimelineStatus = exports.SavedObjectTimelineRuntimeType = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
var _utility_types = require("../../utility_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 *  ColumnHeader Types
 */
const SavedColumnHeaderRuntimeType = runtimeTypes.partial({
  aggregatable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  category: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnHeaderType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  example: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  indexes: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  placeholder: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  searchable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  DataProvider Types
 */
const SavedDataProviderQueryMatchBasicRuntimeType = runtimeTypes.partial({
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  displayField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: runtimeTypes.union([runtimeTypes.null, runtimeTypes.string, runtimeTypes.array(runtimeTypes.string)]),
  displayValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  operator: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedDataProviderQueryMatchRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType)
});
var DataProviderType;
(function (DataProviderType) {
  DataProviderType["default"] = "default";
  DataProviderType["template"] = "template";
})(DataProviderType || (DataProviderType = {}));
const DataProviderTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(DataProviderType.default), runtimeTypes.literal(DataProviderType.template)]);
const SavedDataProviderRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType),
  and: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderQueryMatchRuntimeType)),
  type: (0, _utility_types.unionWithNullType)(DataProviderTypeLiteralRt)
});

/*
 *  Filters Types
 */
const SavedFilterMetaRuntimeType = runtimeTypes.partial({
  alias: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  controlledBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  disabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  formattedValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  index: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  key: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  negate: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  params: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterRuntimeType = runtimeTypes.partial({
  exists: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  meta: (0, _utility_types.unionWithNullType)(SavedFilterMetaRuntimeType),
  match_all: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  missing: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  range: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  script: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  eqlOptionsQuery -> filterQuery Types
 */
const EqlOptionsRuntimeType = runtimeTypes.partial({
  eventCategoryField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  tiebreakerField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  timestampField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  size: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  kqlQuery -> filterQuery Types
 */
const SavedKueryFilterQueryRuntimeType = runtimeTypes.partial({
  kind: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  expression: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSerializedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  kuery: (0, _utility_types.unionWithNullType)(SavedKueryFilterQueryRuntimeType),
  serializedQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  filterQuery: (0, _utility_types.unionWithNullType)(SavedSerializedFilterQueryQueryRuntimeType)
});

/*
 *  DatePicker Range Types
 */
const SavedDateRangePickerRuntimeType = runtimeTypes.partial({
  /* Before the change of all timestamp to ISO string the values of start and from
   * attributes where a number. Specifically UNIX timestamps.
   * To support old timeline's saved object we need to add the number io-ts type
   */
  start: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number])),
  end: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  Favorite Types
 */
const SavedFavoriteRuntimeType = runtimeTypes.partial({
  keySearch: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  favoriteDate: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  fullName: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  userName: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  Sort Types
 */

const SavedSortObject = runtimeTypes.partial({
  columnId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sortDirection: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSortRuntimeType = runtimeTypes.union([runtimeTypes.array(SavedSortObject), SavedSortObject]);

/*
 *  Timeline Statuses
 */
let SavedObjectTimelineStatus;
exports.SavedObjectTimelineStatus = SavedObjectTimelineStatus;
(function (SavedObjectTimelineStatus) {
  SavedObjectTimelineStatus["active"] = "active";
  SavedObjectTimelineStatus["draft"] = "draft";
  SavedObjectTimelineStatus["immutable"] = "immutable";
})(SavedObjectTimelineStatus || (exports.SavedObjectTimelineStatus = SavedObjectTimelineStatus = {}));
const TimelineStatusLiteralRt = runtimeTypes.union([runtimeTypes.literal(SavedObjectTimelineStatus.active), runtimeTypes.literal(SavedObjectTimelineStatus.draft), runtimeTypes.literal(SavedObjectTimelineStatus.immutable)]);
var RowRendererId;
(function (RowRendererId) {
  RowRendererId["alert"] = "alert";
  RowRendererId["alerts"] = "alerts";
  RowRendererId["auditd"] = "auditd";
  RowRendererId["auditd_file"] = "auditd_file";
  RowRendererId["library"] = "library";
  RowRendererId["netflow"] = "netflow";
  RowRendererId["plain"] = "plain";
  RowRendererId["registry"] = "registry";
  RowRendererId["suricata"] = "suricata";
  RowRendererId["system"] = "system";
  RowRendererId["system_dns"] = "system_dns";
  RowRendererId["system_endgame_process"] = "system_endgame_process";
  RowRendererId["system_file"] = "system_file";
  RowRendererId["system_fim"] = "system_fim";
  RowRendererId["system_security_event"] = "system_security_event";
  RowRendererId["system_socket"] = "system_socket";
  RowRendererId["threat_match"] = "threat_match";
  RowRendererId["zeek"] = "zeek";
})(RowRendererId || (RowRendererId = {}));
const RowRendererIdRuntimeType = (0, _utility_types.stringEnum)(RowRendererId, 'RowRendererId');

/*
 *  Saved Object Timeline Types
 */
let SavedObjectTimelineType;
exports.SavedObjectTimelineType = SavedObjectTimelineType;
(function (SavedObjectTimelineType) {
  SavedObjectTimelineType["default"] = "default";
  SavedObjectTimelineType["template"] = "template";
})(SavedObjectTimelineType || (exports.SavedObjectTimelineType = SavedObjectTimelineType = {}));
const SavedObjectTimelineTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(SavedObjectTimelineType.template), runtimeTypes.literal(SavedObjectTimelineType.default)]);
const SavedObjectTimelineTypeLiteralWithNullRt = (0, _utility_types.unionWithNullType)(SavedObjectTimelineTypeLiteralRt);
exports.SavedObjectTimelineTypeLiteralWithNullRt = SavedObjectTimelineTypeLiteralWithNullRt;
const SavedObjectTimelineRuntimeType = runtimeTypes.partial({
  columns: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedColumnHeaderRuntimeType)),
  dataProviders: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderRuntimeType)),
  dataViewId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  eqlOptions: (0, _utility_types.unionWithNullType)(EqlOptionsRuntimeType),
  eventType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  excludedRowRendererIds: (0, _utility_types.unionWithNullType)(runtimeTypes.array(RowRendererIdRuntimeType)),
  favorite: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFavoriteRuntimeType)),
  filters: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFilterRuntimeType)),
  indexNames: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  kqlMode: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  kqlQuery: (0, _utility_types.unionWithNullType)(SavedFilterQueryQueryRuntimeType),
  title: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineVersion: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  timelineType: (0, _utility_types.unionWithNullType)(SavedObjectTimelineTypeLiteralRt),
  dateRange: (0, _utility_types.unionWithNullType)(SavedDateRangePickerRuntimeType),
  savedQueryId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sort: (0, _utility_types.unionWithNullType)(SavedSortRuntimeType),
  status: (0, _utility_types.unionWithNullType)(TimelineStatusLiteralRt),
  created: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  createdBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  updated: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  updatedBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
exports.SavedObjectTimelineRuntimeType = SavedObjectTimelineRuntimeType;