"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthIntervalType = exports.HealthIntervalParameters = exports.HealthIntervalGranularity = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Type of the health interval. You can specify:
 * - a relative interval, e.g. "last_hour" = [now-1h; now] where "now" is when health request is made
 * - a custom interval with "from" and "to" timestamps
 */
let HealthIntervalType;
/**
 * Granularity defines how the whole health interval will be split into smaller sub-intervals.
 * Health stats will be calculated for the whole interval + for each sub-interval.
 * Example: if the interval is "last_day" and the granularity is "hour", stats will be calculated:
 * - 1 time for the last 24 hours
 * - 24 times for each hour in that interval
 */
exports.HealthIntervalType = HealthIntervalType;
(function (HealthIntervalType) {
  HealthIntervalType["last_hour"] = "last_hour";
  HealthIntervalType["last_day"] = "last_day";
  HealthIntervalType["last_week"] = "last_week";
  HealthIntervalType["last_month"] = "last_month";
  HealthIntervalType["last_year"] = "last_year";
  HealthIntervalType["custom_range"] = "custom_range";
})(HealthIntervalType || (exports.HealthIntervalType = HealthIntervalType = {}));
let HealthIntervalGranularity;
/**
 * Time period over which we calculate health stats.
 * This is a "raw" schema for the interval parameters that users can pass to the API.
 */
exports.HealthIntervalGranularity = HealthIntervalGranularity;
(function (HealthIntervalGranularity) {
  HealthIntervalGranularity["minute"] = "minute";
  HealthIntervalGranularity["hour"] = "hour";
  HealthIntervalGranularity["day"] = "day";
  HealthIntervalGranularity["week"] = "week";
  HealthIntervalGranularity["month"] = "month";
})(HealthIntervalGranularity || (exports.HealthIntervalGranularity = HealthIntervalGranularity = {}));
const HealthIntervalParameters = t.union([t.exact(t.type({
  type: t.literal(HealthIntervalType.last_hour),
  granularity: t.literal(HealthIntervalGranularity.minute)
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_day),
  granularity: t.union([t.literal(HealthIntervalGranularity.minute), t.literal(HealthIntervalGranularity.hour)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_week),
  granularity: t.union([t.literal(HealthIntervalGranularity.hour), t.literal(HealthIntervalGranularity.day)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_month),
  granularity: t.union([t.literal(HealthIntervalGranularity.day), t.literal(HealthIntervalGranularity.week)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.last_year),
  granularity: t.union([t.literal(HealthIntervalGranularity.week), t.literal(HealthIntervalGranularity.month)])
})), t.exact(t.type({
  type: t.literal(HealthIntervalType.custom_range),
  granularity: t.union([t.literal(HealthIntervalGranularity.minute), t.literal(HealthIntervalGranularity.hour), t.literal(HealthIntervalGranularity.day), t.literal(HealthIntervalGranularity.week), t.literal(HealthIntervalGranularity.month)]),
  from: _securitysolutionIoTsTypes.IsoDateString,
  to: _securitysolutionIoTsTypes.IsoDateString
}))]);

/**
 * Time period over which we calculate health stats.
 * This interface represents a fully validated and normalized interval object.
 */
exports.HealthIntervalParameters = HealthIntervalParameters;