"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewRuleAttributes = exports.CoverageOverviewResponse = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _request_schema = require("./request_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewRuleAttributes = t.type({
  name: t.string,
  activity: _request_schema.CoverageOverviewRuleActivitySchema
});
exports.CoverageOverviewRuleAttributes = CoverageOverviewRuleAttributes;
const CoverageOverviewResponse = t.exact(t.type({
  /**
   * Map having (tacticId, techniqueId or subtechniqueId) as the key and an array of rule ids as the value
   */
  coverage: t.record(t.string, (0, _securitysolutionIoTsTypes.NonEmptyArray)(t.string)),
  /**
   * Array of unmapped rule ids
   */
  unmapped_rule_ids: t.array(t.string),
  /**
   * Map having ruleId as the key and coverage overview rule data as the value
   */
  rules_data: t.record(t.string, CoverageOverviewRuleAttributes)
}));
exports.CoverageOverviewResponse = CoverageOverviewResponse;