"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewRuleSourceSchema = exports.CoverageOverviewRuleSource = exports.CoverageOverviewRuleActivitySchema = exports.CoverageOverviewRuleActivity = exports.CoverageOverviewRequestBody = exports.CoverageOverviewFilter = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Rule activity (status) filter applicable to two groups of rules
 * - installed from a Fleet package, custom and customized which are installed but customized later on which
 *  can be either enabled or disabled
 * - available to be installed from a Fleet package rules
 */
let CoverageOverviewRuleActivity;
exports.CoverageOverviewRuleActivity = CoverageOverviewRuleActivity;
(function (CoverageOverviewRuleActivity) {
  CoverageOverviewRuleActivity["Enabled"] = "enabled";
  CoverageOverviewRuleActivity["Disabled"] = "disabled";
  CoverageOverviewRuleActivity["Available"] = "available";
})(CoverageOverviewRuleActivity || (exports.CoverageOverviewRuleActivity = CoverageOverviewRuleActivity = {}));
const CoverageOverviewRuleActivitySchema = (0, _securitysolutionIoTsTypes.enumeration)('CoverageOverviewRuleActivity', CoverageOverviewRuleActivity);

/**
 * Rule source (origin) filter representing from where the rules came from
 */
exports.CoverageOverviewRuleActivitySchema = CoverageOverviewRuleActivitySchema;
let CoverageOverviewRuleSource;
exports.CoverageOverviewRuleSource = CoverageOverviewRuleSource;
(function (CoverageOverviewRuleSource) {
  CoverageOverviewRuleSource["Prebuilt"] = "prebuilt";
  CoverageOverviewRuleSource["Custom"] = "custom";
  CoverageOverviewRuleSource["Customized"] = "customized";
})(CoverageOverviewRuleSource || (exports.CoverageOverviewRuleSource = CoverageOverviewRuleSource = {}));
const CoverageOverviewRuleSourceSchema = (0, _securitysolutionIoTsTypes.enumeration)('CoverageOverviewRuleSource', CoverageOverviewRuleSource);
exports.CoverageOverviewRuleSourceSchema = CoverageOverviewRuleSourceSchema;
const CoverageOverviewFilter = t.partial({
  /**
   * A search term to filter the response by rule name, index pattern, MITRE ATT&CK™ tactic or technique
   *
   * @example "Defense Evasion" or "TA0005"
   */
  search_term: _securitysolutionIoTsTypes.NonEmptyString,
  /**
   * An activity filter representing an array combined of CoverageOverviewRuleActivity values to include only specified rules in the response
   */
  activity: (0, _securitysolutionIoTsTypes.NonEmptyArray)(CoverageOverviewRuleActivitySchema),
  /**
   * A source filter representing an array combined of CoverageOverviewRuleSource values to include only specified rules in the response
   */
  source: (0, _securitysolutionIoTsTypes.NonEmptyArray)(CoverageOverviewRuleSourceSchema)
});
exports.CoverageOverviewFilter = CoverageOverviewFilter;
const CoverageOverviewRequestBody = t.partial({
  filter: CoverageOverviewFilter
});
exports.CoverageOverviewRequestBody = CoverageOverviewRequestBody;