"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _badges = require("../../badges");
var _role_table_display = require("../../role_table_display");
var _components = require("../components");
var _user_utils = require("../user_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UsersGridPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleDelete", (usernames, errors) => {
      const {
        users
      } = this.state;
      const filteredUsers = users.filter(({
        username
      }) => {
        return !usernames.includes(username) || errors.includes(username);
      });
      this.setState({
        selection: [],
        showDeleteConfirmation: false,
        users: filteredUsers,
        visibleUsers: this.getVisibleUsers(filteredUsers, this.state.filter, this.state.includeReservedUsers)
      });
    });
    (0, _defineProperty2.default)(this, "getVisibleUsers", (users, filter, includeReservedUsers) => {
      return users.filter(({
        username,
        roles: userRoles,
        full_name: fullName = '',
        email = '',
        metadata = {}
      }) => {
        const normalized = `${username} ${userRoles.join(' ')} ${fullName} ${email}`.toLowerCase();
        const normalizedQuery = filter.toLowerCase();
        return normalized.indexOf(normalizedQuery) !== -1 && (includeReservedUsers || !metadata._reserved);
      });
    });
    (0, _defineProperty2.default)(this, "onIncludeReservedUsersChange", e => {
      this.setState({
        includeReservedUsers: e.target.checked,
        visibleUsers: this.getVisibleUsers(this.state.users, this.state.filter, e.target.checked)
      });
    });
    (0, _defineProperty2.default)(this, "getUserStatusBadges", user => {
      const enabled = user.enabled;
      const reserved = (0, _user_utils.isUserReserved)(user);
      const deprecated = (0, _user_utils.isUserDeprecated)(user);
      const badges = [];
      if (!enabled) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.DisabledBadge, {
          "data-test-subj": "userDisabled"
        }));
      }
      if (reserved) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.ReservedBadge, {
          "data-test-subj": "userReserved",
          tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.users.reservedUserBadgeTooltip",
            defaultMessage: "Reserved users are built-in and cannot be edited or removed."
          })
        }));
      }
      if (deprecated) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.DeprecatedBadge, {
          "data-test-subj": "userDeprecated",
          tooltipContent: (0, _user_utils.getExtendedUserDeprecationNotice)(user)
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        wrap: true
      }, badges.map((badge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        grow: false
      }, badge)));
    });
    (0, _defineProperty2.default)(this, "onCancelDelete", () => {
      this.setState({
        showDeleteConfirmation: false
      });
    });
    this.state = {
      users: [],
      visibleUsers: [],
      roles: [],
      selection: [],
      showDeleteConfirmation: false,
      permissionDenied: false,
      filter: '',
      includeReservedUsers: true,
      isTableLoading: false
    };
  }
  componentDidMount() {
    this.loadUsersAndRoles();
  }
  render() {
    const {
      roles,
      permissionDenied,
      showDeleteConfirmation,
      selection
    } = this.state;
    if (permissionDenied) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
        verticalPosition: "center",
        horizontalPosition: "center",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "securityApp",
        title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.users.deniedPermissionTitle",
          defaultMessage: "You need permission to manage users"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "permissionDeniedMessage"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.users.permissionDeniedToManageUsersDescription",
          defaultMessage: "Contact your system administrator."
        }))
      })));
    }
    const columns = [{
      field: 'username',
      name: _i18n.i18n.translate('xpack.security.management.users.userNameColumnName', {
        defaultMessage: 'User Name'
      }),
      sortable: true,
      render: username => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "userRowUserName"
      }, (0, _public.reactRouterNavigate)(this.props.history, `/edit/${encodeURIComponent(username)}`)), username)
    }, {
      field: 'full_name',
      name: _i18n.i18n.translate('xpack.security.management.users.fullNameColumnName', {
        defaultMessage: 'Full Name'
      }),
      sortable: true,
      truncateText: true,
      render: fullName => {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "userRowFullName"
        }, fullName);
      }
    }, {
      field: 'email',
      name: _i18n.i18n.translate('xpack.security.management.users.emailAddressColumnName', {
        defaultMessage: 'Email Address'
      }),
      sortable: true,
      truncateText: true,
      render: email => {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "userRowEmail"
        }, email);
      }
    }, {
      field: 'roles',
      name: _i18n.i18n.translate('xpack.security.management.users.rolesColumnName', {
        defaultMessage: 'Roles'
      }),
      width: '30%',
      render: rolenames => {
        const roleLinks = rolenames.map((rolename, index) => {
          var _roles$find;
          const roleDefinition = (_roles$find = roles === null || roles === void 0 ? void 0 : roles.find(role => role.name === rolename)) !== null && _roles$find !== void 0 ? _roles$find : rolename;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            key: rolename
          }, /*#__PURE__*/_react.default.createElement(_role_table_display.RoleTableDisplay, {
            role: roleDefinition,
            navigateToApp: this.props.navigateToApp
          }));
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          "data-test-subj": "userRowRoles",
          gutterSize: "s",
          wrap: true
        }, roleLinks);
      }
    }, {
      field: 'metadata',
      name: _i18n.i18n.translate('xpack.security.management.users.statusColumnName', {
        defaultMessage: 'Status'
      }),
      width: '10%',
      sortable: ({
        metadata
      }) => Boolean(metadata && metadata._reserved),
      description: _i18n.i18n.translate('xpack.security.management.users.reservedColumnDescription', {
        defaultMessage: 'Reserved users are built-in and cannot be removed. Only the password can be changed.'
      }),
      render: (metadata, record) => this.getUserStatusBadges(record)
    }];
    const pagination = {
      initialPageSize: 20,
      pageSizeOptions: [10, 20, 50, 100]
    };
    const selectionConfig = {
      itemId: 'username',
      selectable: user => !(user.metadata && user.metadata._reserved),
      selectableMessage: selectable => !selectable ? 'User is a system user' : '',
      onSelectionChange: updatedSelection => this.setState({
        selection: updatedSelection
      })
    };
    const search = {
      toolsLeft: this.renderToolsLeft(),
      toolsRight: this.renderToolsRight(),
      box: {
        incremental: true,
        'data-test-subj': 'searchUsers'
      },
      onChange: query => {
        this.setState({
          filter: query.queryText,
          visibleUsers: this.getVisibleUsers(this.state.users, query.queryText, this.state.includeReservedUsers)
        });
      }
    };
    const sorting = {
      sort: {
        field: 'username',
        direction: 'asc'
      }
    };
    const rowProps = () => {
      return {
        'data-test-subj': 'userRow'
      };
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.users.usersTitle",
        defaultMessage: "Users"
      }),
      rightSideItems: this.props.readOnly ? undefined : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        "data-test-subj": "createUserButton"
      }, (0, _public.reactRouterNavigate)(this.props.history, `/create`), {
        fill: true,
        iconType: "plusInCircleFilled"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.users.createNewUserButtonLabel",
        defaultMessage: "Create user"
      }))]
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), showDeleteConfirmation ? /*#__PURE__*/_react.default.createElement(_components.ConfirmDeleteUsers, {
      onCancel: this.onCancelDelete,
      usersToDelete: selection.map(user => user.username),
      callback: this.handleDelete,
      userAPIClient: this.props.userAPIClient,
      notifications: this.props.notifications
    }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      itemId: "username",
      tableCaption: _i18n.i18n.translate('xpack.security.management.users.tableCaption', {
        defaultMessage: 'Users'
      }),
      rowHeader: "username",
      columns: columns,
      selection: this.props.readOnly ? undefined : selectionConfig,
      pagination: pagination,
      items: this.state.visibleUsers,
      loading: this.state.isTableLoading,
      search: search,
      sorting: sorting,
      rowProps: rowProps,
      isSelectable: true
    }));
  }
  async loadUsersAndRoles() {
    try {
      this.setState({
        isTableLoading: true
      });
      const [users, roles] = await Promise.all([this.props.userAPIClient.getUsers(), this.props.rolesAPIClient.getRoles()]);
      this.setState({
        isTableLoading: false,
        users,
        roles,
        visibleUsers: this.getVisibleUsers(users, this.state.filter, this.state.includeReservedUsers)
      });
    } catch (e) {
      this.setState({
        permissionDenied: e.body.statusCode === 403,
        isTableLoading: false
      });
      if (e.body.statusCode !== 403) {
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.users.fetchingUsersErrorMessage', {
          defaultMessage: 'Error fetching users: {message}',
          values: {
            message: e.body.message
          }
        }));
      }
    }
  }
  renderToolsLeft() {
    const {
      selection
    } = this.state;
    if (selection.length === 0) {
      return;
    }
    const numSelected = selection.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteUserButton",
      color: "danger",
      onClick: () => this.setState({
        showDeleteConfirmation: true
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.deleteUsersButtonLabel",
      defaultMessage: "Delete {numSelected} user{numSelected, plural, one { } other {s}}",
      values: {
        numSelected
      }
    }));
  }
  renderToolsRight() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "showReservedUsersSwitch",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.users.showReservedUsersLabel",
        defaultMessage: "Show reserved users"
      }),
      checked: this.state.includeReservedUsers,
      onChange: this.onIncludeReservedUsersChange
    });
  }
}
exports.UsersGridPage = UsersGridPage;
(0, _defineProperty2.default)(UsersGridPage, "defaultProps", {
  readOnly: false
});