"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RolesAPIClient = void 0;
var _model = require("../../../common/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RolesAPIClient {
  constructor(http) {
    this.http = http;
  }
  async getRoles() {
    return await this.http.get('/api/security/role');
  }
  async getRole(roleName) {
    return await this.http.get(`/api/security/role/${encodeURIComponent(roleName)}`);
  }
  async deleteRole(roleName) {
    await this.http.delete(`/api/security/role/${encodeURIComponent(roleName)}`);
  }
  async saveRole({
    role,
    createOnly = false
  }) {
    await this.http.put(`/api/security/role/${encodeURIComponent(role.name)}`, {
      body: JSON.stringify(this.transformRoleForSave((0, _model.copyRole)(role))),
      query: {
        createOnly
      }
    });
  }
  transformRoleForSave(role) {
    var _role$elasticsearch$r, _role$elasticsearch$r2;
    // Remove any placeholder index privileges
    const isPlaceholderPrivilege = indexPrivilege => {
      if ('clusters' in indexPrivilege && indexPrivilege.clusters && indexPrivilege.clusters.length > 0) {
        return false;
      }
      return indexPrivilege.names.length === 0 && indexPrivilege.privileges.length === 0;
    };
    role.elasticsearch.indices = role.elasticsearch.indices.filter(indexPrivilege => !isPlaceholderPrivilege(indexPrivilege));
    role.elasticsearch.remote_indices = (_role$elasticsearch$r = role.elasticsearch.remote_indices) === null || _role$elasticsearch$r === void 0 ? void 0 : _role$elasticsearch$r.filter(indexPrivilege => !isPlaceholderPrivilege(indexPrivilege));

    // Remove any placeholder query entries
    role.elasticsearch.indices.forEach(index => index.query || delete index.query);
    (_role$elasticsearch$r2 = role.elasticsearch.remote_indices) === null || _role$elasticsearch$r2 === void 0 ? void 0 : _role$elasticsearch$r2.forEach(index => index.query || delete index.query);
    role.kibana.forEach(kibanaPrivilege => {
      // If a base privilege is defined, then do not persist feature privileges
      if (kibanaPrivilege.base.length > 0) {
        kibanaPrivilege.feature = {};
      }
    });

    // @ts-expect-error
    delete role.name;
    delete role.transient_metadata;
    delete role._unrecognized_applications;
    delete role._transform_error;
    return role;
  }
}
exports.RolesAPIClient = RolesAPIClient;