"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPrivilegeForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fromOption = option => option.label;
const toOption = value => ({
  label: value
});
class IndexPrivilegeForm extends _react.Component {
  // This is distinct from the field within `this.state`.
  // We want to make sure that only one request for fields is in-flight at a time,
  // and relying on state for this is error prone.

  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isFieldListLoading", false);
    (0, _defineProperty2.default)(this, "getPrivilegeForm", () => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, this.props.indexType === 'remote_indices' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.clustersFormRowLabel",
          defaultMessage: "Remote clusters"
        }),
        fullWidth: true
      }, this.props.validator.validateRemoteIndexPrivilegeClustersField(this.props.indexPrivilege)), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `clustersInput${this.props.formIndex}`,
        selectedOptions: ('clusters' in this.props.indexPrivilege && this.props.indexPrivilege.clusters ? this.props.indexPrivilege.clusters : []).map(toOption),
        onCreateOption: this.onCreateClusterOption,
        onChange: this.onClustersChange,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.clustersPlaceholder', {
          defaultMessage: 'Add a remote cluster…'
        }),
        fullWidth: true
      }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: this.props.indexType === 'remote_indices' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.remoteIndicesFormRowLabel",
          defaultMessage: "Remote indices"
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.indicesFormRowLabel",
          defaultMessage: "Indices"
        }),
        fullWidth: true
      }, this.props.validator.validateIndexPrivilegeNamesField(this.props.indexPrivilege)), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `indicesInput${this.props.formIndex}`,
        options: this.props.indexPatterns.map(toOption),
        selectedOptions: this.props.indexPrivilege.names.map(toOption),
        onCreateOption: this.onCreateIndexPatternOption,
        onChange: this.onIndexPatternsChange,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.indicesPlaceholder', {
          defaultMessage: 'Add an index pattern…'
        }),
        fullWidth: true
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.privilegesFormRowLabel",
          defaultMessage: "Privileges"
        }),
        fullWidth: true
      }, this.props.validator.validateIndexPrivilegePrivilegesField(this.props.indexPrivilege)), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `privilegesInput${this.props.formIndex}`,
        options: this.props.availableIndexPrivileges.map(toOption),
        selectedOptions: this.props.indexPrivilege.privileges.map(toOption),
        onChange: this.onPrivilegeChange,
        onCreateOption: this.onCreateCustomPrivilege,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.privilegesPlaceholder', {
          defaultMessage: 'Add an action…'
        }),
        fullWidth: true
      })))), this.getFieldLevelControls(), this.getGrantedDocumentsControl());
    });
    (0, _defineProperty2.default)(this, "loadFLSOptions", (indexNames, force = false) => {
      if (this.props.indexType === 'remote_indices' || !force && (this.isFieldListLoading || indexNames.length === 0)) {
        return;
      }
      this.isFieldListLoading = true;
      this.setState({
        isFieldListLoading: true
      });
      this.props.indicesAPIClient.getFields(indexNames.join(',')).then(fields => {
        this.isFieldListLoading = false;
        this.setState({
          flsOptions: fields,
          isFieldListLoading: false
        });
      }).catch(() => {
        this.isFieldListLoading = false;
        this.setState({
          flsOptions: [],
          isFieldListLoading: false
        });
      });
    });
    (0, _defineProperty2.default)(this, "getFieldLevelControls", () => {
      const {
        allowFieldLevelSecurity,
        indexPrivilege,
        isRoleReadOnly
      } = this.props;
      const {
        grant,
        except
      } = this.getFieldSecurity(indexPrivilege);
      if (!allowFieldLevelSecurity) {
        return null;
      }
      if (isRoleReadOnly && !this.state.fieldSecurityExpanded) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, !isRoleReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": `restrictFieldsQuery${this.props.formIndex}`,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantFieldPrivilegesLabel",
          defaultMessage: "Grant access to specific fields"
        }),
        compressed: true,
        checked: this.state.fieldSecurityExpanded,
        onChange: this.toggleFieldSecurity
      })), this.state.fieldSecurityExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantedFieldsFormRowLabel",
          defaultMessage: "Granted fields"
        }),
        fullWidth: true,
        className: "indexPrivilegeForm__grantedFieldsRow",
        helpText: !isRoleReadOnly && grant.length === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantedFieldsFormRowHelpText",
          defaultMessage: "If no fields are granted, then users assigned to this role will not be able to see any data for this index."
        }) : undefined
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `fieldInput${this.props.formIndex}`,
        options: this.state.flsOptions.map(toOption),
        selectedOptions: grant.map(toOption),
        onCreateOption: this.onCreateGrantedField,
        onChange: this.onGrantedFieldsChange,
        isDisabled: this.props.isRoleReadOnly,
        async: true,
        isLoading: this.state.isFieldListLoading,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.fieldPlaceholder', {
          defaultMessage: 'Add a field pattern…'
        }),
        fullWidth: true
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.deniedFieldsFormRowLabel",
          defaultMessage: "Denied fields"
        }),
        fullWidth: true,
        className: "indexPrivilegeForm__deniedFieldsRow"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `deniedFieldInput${this.props.formIndex}`,
        options: this.state.flsOptions.map(toOption),
        selectedOptions: except.map(toOption),
        onCreateOption: this.onCreateDeniedField,
        onChange: this.onDeniedFieldsChange,
        isDisabled: isRoleReadOnly,
        async: true,
        isLoading: this.state.isFieldListLoading,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deniedFieldPlaceholder', {
          defaultMessage: 'Add a field pattern…'
        }),
        fullWidth: true
      })))))));
    });
    (0, _defineProperty2.default)(this, "getGrantedDocumentsControl", () => {
      var _indexPrivilege$query;
      const {
        allowDocumentLevelSecurity,
        indexPrivilege,
        isRoleReadOnly
      } = this.props;
      if (!allowDocumentLevelSecurity) {
        return null;
      }
      if (this.props.isRoleReadOnly && !this.state.queryExpanded) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, !this.props.isRoleReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": `restrictDocumentsQuery${this.props.formIndex}`,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.grantReadPrivilegesLabel",
          defaultMessage: "Grant read privileges to specific documents"
        }),
        compressed: true,
        checked: this.state.queryExpanded,
        onChange: this.toggleDocumentQuery,
        disabled: isRoleReadOnly
      })), this.state.queryExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.grantedDocumentsQueryFormRowLabel",
          defaultMessage: "Granted documents query"
        }),
        fullWidth: true,
        "data-test-subj": `queryInput${this.props.formIndex}`
      }, /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
        languageId: "xjson",
        width: "100%",
        fullWidth: true,
        height: this.state.documentQueryEditorHeight,
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.grantedDocumentsQueryEditorAriaLabel', {
          defaultMessage: 'Granted documents query editor'
        }),
        value: (_indexPrivilege$query = indexPrivilege.query) !== null && _indexPrivilege$query !== void 0 ? _indexPrivilege$query : '',
        onChange: this.onQueryChange,
        options: {
          readOnly: this.props.isRoleReadOnly,
          minimap: {
            enabled: false
          },
          // Prevent an empty form from showing an error
          renderValidationDecorations: indexPrivilege.query ? 'editable' : 'off'
        },
        editorDidMount: this.editorDidMount
      })))));
    });
    (0, _defineProperty2.default)(this, "editorDidMount", editor => {
      /**
       * Resize the editor based on the contents of the editor itself.
       * Adapted from https://github.com/microsoft/monaco-editor/issues/794#issuecomment-688959283
       */

      const minHeight = 100;
      const maxHeight = 1000;
      const updateHeight = () => {
        const contentHeight = Math.min(maxHeight, Math.max(minHeight, editor.getContentHeight()));
        this.setState({
          documentQueryEditorHeight: `${contentHeight}px`
        });
      };
      editor.onDidContentSizeChange(updateHeight);
      updateHeight();
    });
    (0, _defineProperty2.default)(this, "toggleDocumentQuery", () => {
      const willToggleOff = this.state.queryExpanded;
      const willToggleOn = !willToggleOff;

      // If turning off, then save the current query in state so that we can restore it if the user changes their mind.
      this.setState({
        queryExpanded: !this.state.queryExpanded,
        documentQuery: willToggleOff ? this.props.indexPrivilege.query : this.state.documentQuery
      });

      // If turning off, then remove the query from the Index Privilege
      if (willToggleOff) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          query: ''
        });
      }

      // If turning on, then restore the saved query if available
      if (willToggleOn && !this.props.indexPrivilege.query && this.state.documentQuery) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          query: this.state.documentQuery
        });
      }
    });
    (0, _defineProperty2.default)(this, "toggleFieldSecurity", () => {
      const willToggleOff = this.state.fieldSecurityExpanded;
      const willToggleOn = !willToggleOff;
      const {
        grant,
        except
      } = this.getFieldSecurity(this.props.indexPrivilege);

      // If turning off, then save the current configuration in state so that we can restore it if the user changes their mind.
      this.setState({
        fieldSecurityExpanded: !this.state.fieldSecurityExpanded,
        grantedFields: willToggleOff ? grant : this.state.grantedFields,
        exceptedFields: willToggleOff ? except : this.state.exceptedFields
      });

      // If turning off, then remove the field security from the Index Privilege
      if (willToggleOff) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          field_security: {
            grant: ['*'],
            except: []
          }
        });
      }

      // If turning on, then restore the saved field security if available
      const hasConfiguredFieldSecurity = this.isFieldSecurityConfigured(this.props.indexPrivilege);
      const hasSavedFieldSecurity = this.state.exceptedFields.length > 0 || this.state.grantedFields.length > 0;

      // If turning on, then request available fields
      if (willToggleOn) {
        this.loadFLSOptions(this.props.indexPrivilege.names);
      }
      if (willToggleOn && !hasConfiguredFieldSecurity && hasSavedFieldSecurity) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          field_security: {
            grant: this.state.grantedFields,
            except: this.state.exceptedFields
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "onCreateClusterOption", option => {
      const nextClusters = ('clusters' in this.props.indexPrivilege && this.props.indexPrivilege.clusters ? this.props.indexPrivilege.clusters : []).concat([option]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        clusters: nextClusters
      });
    });
    (0, _defineProperty2.default)(this, "onClustersChange", nextOptions => {
      const clusters = nextOptions.map(fromOption);
      this.props.onChange({
        ...this.props.indexPrivilege,
        clusters
      });
    });
    (0, _defineProperty2.default)(this, "onCreateIndexPatternOption", option => {
      const newIndexPatterns = this.props.indexPrivilege.names.concat([option]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        names: newIndexPatterns
      });
      // If FLS controls are visible, then forcefully request a new set of options
      if (this.state.fieldSecurityExpanded) {
        this.loadFLSOptions(newIndexPatterns, true);
      }
    });
    (0, _defineProperty2.default)(this, "onIndexPatternsChange", newPatterns => {
      const names = newPatterns.map(fromOption);
      this.props.onChange({
        ...this.props.indexPrivilege,
        names
      });
      // If FLS controls are visible, then forcefully request a new set of options
      if (this.state.fieldSecurityExpanded) {
        this.loadFLSOptions(names, true);
      }
    });
    (0, _defineProperty2.default)(this, "onPrivilegeChange", newPrivileges => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        privileges: newPrivileges.map(fromOption)
      });
    });
    (0, _defineProperty2.default)(this, "onCreateCustomPrivilege", customPrivilege => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        privileges: [...this.props.indexPrivilege.privileges, customPrivilege]
      });
    });
    (0, _defineProperty2.default)(this, "onQueryChange", query => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        query
      });
    });
    (0, _defineProperty2.default)(this, "onCreateGrantedField", grant => {
      if (!this.props.indexPrivilege.field_security || !this.props.indexPrivilege.field_security.grant) {
        return;
      }
      const newGrants = this.props.indexPrivilege.field_security.grant.concat([grant]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          grant: newGrants
        }
      });
    });
    (0, _defineProperty2.default)(this, "onGrantedFieldsChange", grantedFields => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          grant: grantedFields.map(fromOption)
        }
      });
    });
    (0, _defineProperty2.default)(this, "onCreateDeniedField", except => {
      if (!this.props.indexPrivilege.field_security || !this.props.indexPrivilege.field_security.except) {
        return;
      }
      const newExcepts = this.props.indexPrivilege.field_security.except.concat([except]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          except: newExcepts
        }
      });
    });
    (0, _defineProperty2.default)(this, "onDeniedFieldsChange", deniedFields => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          except: deniedFields.map(fromOption)
        }
      });
    });
    (0, _defineProperty2.default)(this, "getFieldSecurity", indexPrivilege => {
      const {
        grant = [],
        except = []
      } = indexPrivilege.field_security || {};
      return {
        grant,
        except
      };
    });
    (0, _defineProperty2.default)(this, "isFieldSecurityConfigured", indexPrivilege => {
      const {
        grant,
        except
      } = this.getFieldSecurity(indexPrivilege);
      return except.length > 0 || grant.length > 0 && !_lodash.default.isEqual(grant, ['*']);
    });
    const {
      grant: _grant,
      except: _except
    } = this.getFieldSecurity(props.indexPrivilege);
    this.state = {
      queryExpanded: !!props.indexPrivilege.query,
      fieldSecurityExpanded: this.isFieldSecurityConfigured(props.indexPrivilege),
      grantedFields: _grant,
      exceptedFields: _except,
      documentQuery: props.indexPrivilege.query,
      documentQueryEditorHeight: '100px',
      isFieldListLoading: false,
      flsOptions: []
    };
  }
  componentDidMount() {
    if (this.state.fieldSecurityExpanded && this.props.allowFieldLevelSecurity) {
      this.loadFLSOptions(this.props.indexPrivilege.names);
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      className: "index-privilege-form"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued"
    }, this.getPrivilegeForm())), !this.props.isRoleReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": this.props.indexType === 'remote_indices' ? _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deleteRemoteIndexPrivilegeAriaLabel', {
        defaultMessage: 'Delete remote index privilege'
      }) : _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deleteIndexPrivilegeAriaLabel', {
        defaultMessage: 'Delete index privilege'
      }),
      color: 'danger',
      onClick: this.props.onDelete,
      iconType: 'trash'
    }))));
  }
}
exports.IndexPrivilegeForm = IndexPrivilegeForm;