"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterPrivileges = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _model = require("../../../../../../common/model");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ClusterPrivileges extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "buildComboBox", items => {
      const {
        role,
        editable
      } = this.props;
      const options = items.map(i => ({
        label: i
      }));
      const selectedOptions = (role.elasticsearch.cluster || []).map(k => ({
        label: k
      }));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: 'clusterPrivs'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.clusterPrivilegeForm.clusterPrivilegesAriaLabel', {
          defaultMessage: 'Cluster privileges'
        }),
        "data-test-subj": 'cluster-privileges-combobox',
        options: options,
        selectedOptions: selectedOptions,
        onChange: this.onClusterPrivilegesChange,
        onCreateOption: this.onCreateCustomPrivilege,
        isDisabled: (0, _model.isRoleReadOnly)(role) || !editable,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.clusterPrivileges.placeholder', {
          defaultMessage: 'Add an action…'
        })
      }));
    });
    (0, _defineProperty2.default)(this, "onClusterPrivilegesChange", selectedPrivileges => {
      this.props.onChange(selectedPrivileges.map(priv => priv.label));
    });
    (0, _defineProperty2.default)(this, "onCreateCustomPrivilege", customPrivilege => {
      this.props.onChange([...this.props.role.elasticsearch.cluster, customPrivilege]);
    });
    (0, _defineProperty2.default)(this, "getAvailableClusterPrivileges", () => {
      const availableClusterPrivileges = [...this.props.builtinClusterPrivileges, ...this.props.role.elasticsearch.cluster];
      return _lodash.default.uniq(availableClusterPrivileges);
    });
  }
  render() {
    const availableClusterPrivileges = this.getAvailableClusterPrivileges();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, this.buildComboBox(availableClusterPrivileges));
  }
}
exports.ClusterPrivileges = ClusterPrivileges;
(0, _defineProperty2.default)(ClusterPrivileges, "defaultProps", {
  editable: true
});