"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyFlyout = void 0;
exports.mapCreateApiKeyValues = mapCreateApiKeyValues;
exports.mapUpdateApiKeyValues = mapUpdateApiKeyValues;
exports.validate = validate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _doc_link = require("../../../components/doc_link");
var _form_flyout = require("../../../components/form_flyout");
var _use_current_user = require("../../../components/use_current_user");
var _use_form = require("../../../components/use_form");
var _use_initial_focus = require("../../../components/use_initial_focus");
var _roles_api_client = require("../../roles/roles_api_client");
var _api_keys_api_client = require("../api_keys_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDefaultValues = {
  name: '',
  customExpiration: false,
  expiration: '',
  includeMetadata: false,
  metadata: '{}',
  customPrivileges: false,
  role_descriptors: '{}'
};
const ApiKeyFlyout = ({
  onSuccess,
  onCancel,
  apiKey,
  readonly = false
}) => {
  var _body, _form$values;
  let formTitle = 'Create API Key';
  let inProgressButtonText = 'Creating API Key…';
  let errorTitle = 'create API key';
  const {
    value: currentUser,
    loading: isLoadingCurrentUser
  } = (0, _use_current_user.useCurrentUser)();
  let canEditApiKey = false;
  let defaultValues = defaultDefaultValues;
  if (apiKey) {
    defaultValues = retrieveValuesFromApiKeyToDefaultFlyout(apiKey);
    canEditApiKey = isEditable(currentUser, apiKey);
    if (readonly || !canEditApiKey) {
      formTitle = 'API key details';
      inProgressButtonText = ''; // This won't be seen since Submit will be disabled
      errorTitle = '';
    } else {
      formTitle = 'Update API Key';
      inProgressButtonText = 'Updating API Key…';
      errorTitle = 'update API key';
    }
  }
  const {
    services
  } = (0, _public.useKibana)();
  const [{
    value: roles,
    loading: isLoadingRoles
  }, getRoles] = (0, _useAsyncFn.default)(() => new _roles_api_client.RolesAPIClient(services.http).getRoles(), [services.http]);
  const [form, eventHandlers] = (0, _use_form.useForm)({
    onSubmit: async values => {
      try {
        if (apiKey) {
          const updateApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).updateApiKey(mapUpdateApiKeyValues(apiKey.id, values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(undefined, updateApiKeyResponse);
        } else {
          const createApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).createApiKey(mapCreateApiKeyValues(values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(createApiKeyResponse, undefined);
        }
      } catch (error) {
        throw error;
      }
    },
    validate,
    defaultValues
  });
  const isLoading = isLoadingCurrentUser || isLoadingRoles;
  (0, _react.useEffect)(() => {
    getRoles();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    if (currentUser && roles) {
      const userPermissions = currentUser.roles.reduce((accumulator, roleName) => {
        const role = roles.find(r => r.name === roleName);
        if (role) {
          accumulator[role.name] = role.elasticsearch;
        }
        return accumulator;
      }, {});
      if (!form.touched.role_descriptors && !apiKey) {
        form.setValue('role_descriptors', JSON.stringify(userPermissions, null, 2));
      }
    }
  }, [currentUser, roles]); // eslint-disable-line react-hooks/exhaustive-deps

  const firstFieldRef = (0, _use_initial_focus.useInitialFocus)([isLoading]);
  return /*#__PURE__*/_react.default.createElement(_form_flyout.FormFlyout, {
    title: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.title', {
      defaultMessage: `{formTitle}`,
      values: {
        formTitle
      }
    }),
    onCancel: onCancel,
    onSubmit: form.submit,
    submitButtonText: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.submitButton', {
      defaultMessage: `{isSubmitting, select, true{{inProgressButtonText}} other{{formTitle}}}`,
      values: {
        isSubmitting: form.isSubmitting,
        inProgressButtonText,
        formTitle
      }
    }),
    isLoading: form.isSubmitting,
    isDisabled: isLoading || form.isSubmitted && form.isInvalid || readonly || apiKey && !canEditApiKey,
    isSubmitButtonHidden: readonly || !!apiKey && !canEditApiKey,
    size: "s",
    ownFocus: true
  }, form.submitError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.errorMessage', {
      defaultMessage: 'Could not {errorTitle}',
      values: {
        errorTitle
      }
    }),
    color: "danger"
  }, ((_body = form.submitError.body) === null || _body === void 0 ? void 0 : _body.message) || form.submitError.message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({
    component: "form",
    isInvalid: form.isInvalid,
    error: Object.values(form.errors),
    invalidCallout: !form.submitError && form.isSubmitted ? 'above' : 'none'
  }, eventHandlers), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.changePasswordFlyout.userLabel', {
      defaultMessage: 'User'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      textOverflow: 'ellipsis'
    },
    "data-test-subj": "apiKeyFlyoutUsername"
  }, apiKey ? apiKey.username : currentUser === null || currentUser === void 0 ? void 0 : currentUser.username), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.nameLabel', {
      defaultMessage: 'Name'
    }),
    error: form.errors.name,
    isInvalid: form.touched.name && !!form.errors.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    defaultValue: form.values.name,
    isInvalid: form.touched.name && !!form.errors.name,
    inputRef: firstFieldRef,
    disabled: !!apiKey || readonly,
    fullWidth: true,
    "data-test-subj": "apiKeyNameInput"
  })), !!apiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.statusLabel', {
      defaultMessage: 'Status'
    })
  }, determineReadonlyExpiration((_form$values = form.values) === null || _form$values === void 0 ? void 0 : _form$values.expiration))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.customPrivilegesLabel', {
      defaultMessage: 'Restrict privileges'
    }),
    checked: form.values.customPrivileges,
    "data-test-subj": "apiKeysRoleDescriptorsSwitch",
    onChange: e => form.setValue('customPrivileges', e.target.checked),
    disabled: readonly || apiKey && !canEditApiKey
  }), form.values.customPrivileges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "apiKeysRoleDescriptorsCodeEditor",
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.roleDescriptorsHelpText",
      defaultMessage: "Learn how to structure role descriptors."
    })),
    error: form.errors.role_descriptors,
    isInvalid: form.touched.role_descriptors && !!form.errors.role_descriptors
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
    value: form.values.role_descriptors,
    onChange: value => form.setValue('role_descriptors', value),
    languageId: "xjson",
    height: 200,
    options: {
      readOnly: readonly || apiKey && !canEditApiKey
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), !apiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.customExpirationLabel', {
      defaultMessage: 'Expire after time'
    }),
    checked: form.values.customExpiration,
    onChange: e => form.setValue('customExpiration', e.target.checked),
    disabled: readonly || !!apiKey,
    "data-test-subj": "apiKeyCustomExpirationSwitch"
  }), form.values.customExpiration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: form.errors.expiration,
    isInvalid: form.touched.expiration && !!form.errors.expiration && !apiKey,
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.customExpirationInputLabel', {
      defaultMessage: 'Lifetime'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    append: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.expirationUnit', {
      defaultMessage: 'days'
    }),
    name: "expiration",
    min: 0,
    defaultValue: form.values.expiration,
    isInvalid: form.touched.expiration && !!form.errors.expiration && !apiKey,
    fullWidth: true,
    "data-test-subj": "apiKeyCustomExpirationInput",
    disabled: readonly || !!apiKey
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.includeMetadataLabel', {
      defaultMessage: 'Include metadata'
    }),
    "data-test-subj": "apiKeysMetadataSwitch",
    checked: form.values.includeMetadata,
    disabled: readonly || apiKey && !canEditApiKey,
    onChange: e => form.setValue('includeMetadata', e.target.checked)
  }), form.values.includeMetadata && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "apiKeysMetadataCodeEditor",
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.metadataHelpText",
      defaultMessage: "Learn how to structure metadata."
    })),
    error: form.errors.metadata,
    isInvalid: form.touched.metadata && !!form.errors.metadata
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
    value: form.values.metadata,
    onChange: value => form.setValue('metadata', value),
    languageId: "xjson",
    height: 200,
    options: {
      readOnly: readonly || apiKey && !canEditApiKey
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement("input", {
    type: "submit",
    hidden: true
  }))));
};
exports.ApiKeyFlyout = ApiKeyFlyout;
function validate(values) {
  const errors = {};
  if (!values.name) {
    errors.name = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.nameRequired', {
      defaultMessage: 'Enter a name.'
    });
  }
  if (values.customExpiration) {
    const parsedExpiration = parseFloat(values.expiration);
    if (isNaN(parsedExpiration) || parsedExpiration <= 0) {
      errors.expiration = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.expirationRequired', {
        defaultMessage: 'Enter a valid duration or disable this option.'
      });
    }
  }
  if (values.customPrivileges) {
    if (!values.role_descriptors) {
      errors.role_descriptors = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.roleDescriptorsRequired', {
        defaultMessage: 'Enter role descriptors or disable this option.'
      });
    } else {
      try {
        JSON.parse(values.role_descriptors);
      } catch (e) {
        errors.role_descriptors = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
          defaultMessage: 'Enter valid JSON.'
        });
      }
    }
  }
  if (values.includeMetadata) {
    if (!values.metadata) {
      errors.metadata = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.metadataRequired', {
        defaultMessage: 'Enter metadata or disable this option.'
      });
    } else {
      try {
        JSON.parse(values.metadata);
      } catch (e) {
        errors.metadata = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
          defaultMessage: 'Enter valid JSON.'
        });
      }
    }
  }
  return errors;
}
function mapCreateApiKeyValues(values) {
  return {
    name: values.name,
    expiration: values.customExpiration && values.expiration ? `${values.expiration}d` : undefined,
    role_descriptors: values.customPrivileges && values.role_descriptors ? JSON.parse(values.role_descriptors) : undefined,
    metadata: values.includeMetadata && values.metadata ? JSON.parse(values.metadata) : undefined
  };
}
function mapUpdateApiKeyValues(id, values) {
  return {
    id,
    role_descriptors: values.customPrivileges && values.role_descriptors ? JSON.parse(values.role_descriptors) : undefined,
    metadata: values.includeMetadata && values.metadata ? JSON.parse(values.metadata) : {}
  };
}
function isEditable(currentUser, apiKey) {
  let result = false;
  const isApiKeyOwner = currentUser && currentUser.username === apiKey.username;
  const isNotExpired = !apiKey.expiration || (0, _momentTimezone.default)(apiKey.expiration).isAfter();
  if (isApiKeyOwner && isNotExpired) {
    result = true;
  }
  return result;
}
function determineReadonlyExpiration(expiration) {
  const DATE_FORMAT = 'MMMM Do YYYY HH:mm:ss';
  if (!expiration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "primary",
      "data-test-subj": "apiKeyStatus"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.statusActive",
      defaultMessage: "Active"
    }));
  }
  const expirationInt = parseInt(expiration, 10);
  if (Date.now() > expirationInt) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued",
      "data-test-subj": "apiKeyStatus"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.statusExpired",
      defaultMessage: "Expired"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    "data-test-subj": "apiKeyStatus"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _momentTimezone.default)(expirationInt).format(DATE_FORMAT)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.statusExpires",
    defaultMessage: "Expires {timeFromNow}",
    values: {
      timeFromNow: (0, _momentTimezone.default)(expirationInt).fromNow()
    }
  })));
}
function retrieveValuesFromApiKeyToDefaultFlyout(apiKey) {
  var _apiKey$role_descript;
  // Collect data from the selected API key to pre-populate the form
  const doesMetadataExist = Object.keys(apiKey.metadata).length > 0;
  const doCustomPrivilegesExist = Object.keys((_apiKey$role_descript = apiKey.role_descriptors) !== null && _apiKey$role_descript !== void 0 ? _apiKey$role_descript : 0).length > 0;
  return {
    name: apiKey.name,
    customExpiration: !!apiKey.expiration,
    expiration: !!apiKey.expiration ? apiKey.expiration.toString() : '',
    includeMetadata: doesMetadataExist,
    metadata: doesMetadataExist ? JSON.stringify(apiKey.metadata, null, 2) : '{}',
    customPrivileges: doCustomPrivilegesExist,
    role_descriptors: doCustomPrivilegesExist ? JSON.stringify(apiKey.role_descriptors, null, 2) : '{}'
  };
}