"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenField = exports.SelectableTokenField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TokenField = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, (0, _extends2.default)({}, props, {
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: props.value
    }, copyText => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.security.copyTokenField.copyButton', {
        defaultMessage: 'Copy to clipboard'
      }),
      iconType: "copyClipboard",
      color: "success",
      style: {
        backgroundColor: 'transparent'
      },
      onClick: copyText
    })),
    style: {
      backgroundColor: 'transparent'
    },
    readOnly: true
  }), /*#__PURE__*/_react.default.createElement("input", {
    type: "text",
    "aria-label": _i18n.i18n.translate('xpack.security.copyTokenField.tokenLabel', {
      defaultMessage: 'Token'
    }),
    className: "euiFieldText euiFieldText--inGroup",
    value: props.value,
    style: {
      fontFamily: _uiTheme.euiThemeVars.euiCodeFontFamily,
      fontSize: _uiTheme.euiThemeVars.euiFontSizeXS
    },
    onFocus: event => event.currentTarget.select(),
    readOnly: true
  }));
};
exports.TokenField = TokenField;
const SelectableTokenField = props => {
  const {
    options,
    ...rest
  } = props;
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const [selectedOption, setSelectedOption] = _react.default.useState(options[0]);
  const selectedIndex = options.findIndex(c => c.key === selectedOption.key);
  const closePopover = () => setIsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(TokenField, (0, _extends2.default)({}, rest, {
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "arrowDown",
        iconSide: "right",
        color: "success",
        onClick: () => setIsPopoverOpen(!isPopoverOpen)
      }, selectedOption.label),
      isOpen: isPopoverOpen,
      panelPaddingSize: "none",
      closePopover: closePopover
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      initialFocusedItemIndex: selectedIndex * 2,
      items: options.reduce((items, option, i) => {
        items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: option.key,
          icon: option.icon,
          layoutAlign: "top",
          onClick: () => {
            closePopover();
            setSelectedOption(option);
          }
        }, /*#__PURE__*/_react.default.createElement("strong", null, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("p", null, option.description))));
        if (i < options.length - 1) {
          items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            key: `${option.key}-seperator`,
            margin: "none"
          }));
        }
        return items;
      }, [])
    })),
    value: selectedOption.value
  }));
};
exports.SelectableTokenField = SelectableTokenField;