"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accountManagementApp = exports.Providers = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _components = require("../components");
var _breadcrumb = require("../components/breadcrumb");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const accountManagementApp = Object.freeze({
  id: 'security_account',
  create({
    application,
    authc,
    getStartServices,
    securityApiClients
  }) {
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.account.breadcrumb', {
        defaultMessage: 'User settings'
      }),
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      appRoute: '/security/account',
      async mount({
        element,
        theme$,
        history
      }) {
        const [[coreStart], {
          AccountManagementPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./account_management_page')))]);
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          theme$: theme$,
          history: history,
          authc: authc,
          securityApiClients: securityApiClients
        }, /*#__PURE__*/_react.default.createElement(AccountManagementPage, null)), element);
        return () => (0, _reactDom.unmountComponentAtNode)(element);
      }
    });
  }
});
exports.accountManagementApp = accountManagementApp;
const Providers = ({
  services,
  theme$,
  history,
  authc,
  securityApiClients,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_components.AuthenticationProvider, {
  authc: authc
}, /*#__PURE__*/_react.default.createElement(_components.SecurityApiClientsProvider, securityApiClients, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
  theme$: theme$
}, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange
}, children)))))));
exports.Providers = Providers;