"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightTreeNode = void 0;
var _react = require("react");
var _uuid = require("uuid");
var _highlight_context = require("./highlight_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHighlightTreeNode = () => {
  const idRef = (0, _react.useRef)((0, _uuid.v4)());
  const {
    selectedRow,
    setStore
  } = (0, _highlight_context.useHighlightContext)();
  const highlight = value => {
    setStore({
      id: idRef.current,
      ...value
    });
  };
  const isHighlighted = () => {
    return selectedRow === idRef.current;
  };
  return {
    id: idRef.current,
    highlight,
    isHighlighted
  };
};
exports.useHighlightTreeNode = useHighlightTreeNode;