"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../../lib");
var _shard_details_tree = require("./shard_details_tree");
var _percentage_badge = require("../../percentage_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasVisibleOperation = ops => {
  for (const op of ops) {
    var _op$children;
    if (op.visible) {
      return true;
    }
    if ((_op$children = op.children) !== null && _op$children !== void 0 && _op$children.length && hasVisibleOperation(op.children)) {
      return true;
    }
  }
  return false;
};
const ShardDetails = ({
  index,
  shard,
  operations
}) => {
  const {
    relative,
    time
  } = shard;
  const [shardVisibility, setShardVisibility] = (0, _react.useState)(() => hasVisibleOperation(operations.map(op => {
    var _op$treeRoot;
    return (_op$treeRoot = op.treeRoot) !== null && _op$treeRoot !== void 0 ? _op$treeRoot : op;
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "prfDevTool__profileTree__shard__header-flex-item"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "prfDevTool__profileTree__shardDetails",
    onClick: () => setShardVisibility(!shardVisibility),
    "data-test-subj": "openCloseShardDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: shardVisibility ? 'arrowDown' : 'arrowRight'
  }), "[", shard.id[0], "][", shard.id[2], "]")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "prfDevTool__profileTree__shard__header-flex-item"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "prfDevTool__shardDetails--dim"
  }, /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
    timePercentage: String(relative),
    label: (0, _lib.msToPretty)(time, 3),
    valueType: 'time'
  })))), shardVisibility ? operations.map((data, idx) => /*#__PURE__*/_react.default.createElement(_shard_details_tree.ShardDetailTree, {
    key: idx,
    index: index,
    shard: shard,
    data: data
  })) : null);
};
exports.ShardDetails = ShardDetails;