"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveSavedSearch = void 0;
var _constants = require("./constants");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const hasDuplicatedTitle = async (title, contentManagement) => {
  if (!title) {
    return;
  }
  const response = await contentManagement.search({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    query: {
      text: `"${title}"`
    },
    options: {
      searchFields: ['title'],
      fields: ['title']
    }
  });
  return response.hits.some(obj => obj.attributes.title.toLowerCase() === title.toLowerCase());
};

/** @internal **/
const saveSavedSearch = async (savedSearch, options, contentManagement, savedObjectsTagging) => {
  var _savedSearch$tags;
  const isNew = options.copyOnSave || !savedSearch.id;
  if (savedSearch.title) {
    if (isNew && !options.isTitleDuplicateConfirmed && options.onTitleDuplicate && (await hasDuplicatedTitle(savedSearch.title, contentManagement))) {
      options.onTitleDuplicate();
      return;
    }
  }
  const {
    searchSourceJSON,
    references: originalReferences
  } = savedSearch.searchSource.serialize();
  const references = savedObjectsTagging ? savedObjectsTagging.ui.updateTagsReferences(originalReferences, (_savedSearch$tags = savedSearch.tags) !== null && _savedSearch$tags !== void 0 ? _savedSearch$tags : []) : originalReferences;
  const resp = isNew ? await contentManagement.create({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    data: (0, _saved_searches_utils.toSavedSearchAttributes)(savedSearch, searchSourceJSON),
    options: {
      references
    }
  }) : await contentManagement.update({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    id: savedSearch.id,
    data: (0, _saved_searches_utils.toSavedSearchAttributes)(savedSearch, searchSourceJSON),
    options: {
      references
    }
  });
  return resp.item.id;
};
exports.saveSavedSearch = saveSavedSearch;