"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trapErrors = fn => {
  try {
    fn();
  } catch (e) {
    // trap
  }
};
class TagsClient {
  constructor({
    http,
    changeListener
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "changeListener", void 0);
    this.http = http;
    this.changeListener = changeListener;
  }

  // public APIs from ITagsClient

  async create(attributes) {
    const {
      tag
    } = await this.http.post('/api/saved_objects_tagging/tags/create', {
      body: JSON.stringify(attributes)
    });
    trapErrors(() => {
      if (this.changeListener) {
        this.changeListener.onCreate(tag);
      }
    });
    return tag;
  }
  async update(id, attributes) {
    const {
      tag
    } = await this.http.post(`/api/saved_objects_tagging/tags/${id}`, {
      body: JSON.stringify(attributes)
    });
    trapErrors(() => {
      if (this.changeListener) {
        const {
          id: newId,
          ...newAttributes
        } = tag;
        this.changeListener.onUpdate(newId, newAttributes);
      }
    });
    return tag;
  }
  async get(id) {
    const {
      tag
    } = await this.http.get(`/api/saved_objects_tagging/tags/${id}`);
    return tag;
  }
  async getAll({
    asSystemRequest
  } = {}) {
    const fetchOptions = {
      asSystemRequest
    };
    const {
      tags
    } = await this.http.get('/api/saved_objects_tagging/tags', fetchOptions);
    trapErrors(() => {
      if (this.changeListener) {
        this.changeListener.onGetAll(tags);
      }
    });
    return tags;
  }
  async delete(id) {
    await this.http.delete(`/api/saved_objects_tagging/tags/${id}`);
    trapErrors(() => {
      if (this.changeListener) {
        this.changeListener.onDelete(id);
      }
    });
  }

  // internal APIs from ITagInternalClient

  async find({
    page,
    perPage,
    search
  }) {
    return await this.http.get('/internal/saved_objects_tagging/tags/_find', {
      query: {
        page,
        perPage,
        search
      }
    });
  }
  async bulkDelete(tagIds) {
    await this.http.post('/internal/saved_objects_tagging/tags/_bulk_delete', {
      body: JSON.stringify({
        ids: tagIds
      })
    });
    trapErrors(() => {
      if (this.changeListener) {
        tagIds.forEach(tagId => {
          this.changeListener.onDelete(tagId);
        });
      }
    });
  }
}
exports.TagsClient = TagsClient;