"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isModifiedOrPrevented = exports.TagTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tablePagination = {
  initialPageSize: 20,
  pageSizeOptions: [5, 10, 20, 50]
};
const sorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const isModifiedOrPrevented = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey || event.defaultPrevented;
exports.isModifiedOrPrevented = isModifiedOrPrevented;
const TagTable = ({
  loading,
  capabilities,
  tags,
  initialQuery,
  allowSelection,
  onQueryChange,
  selectedTags,
  onSelectionChange,
  onShowRelations,
  getTagRelationUrl,
  actionBar,
  actions
}) => {
  const tableRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (tableRef.current) {
      tableRef.current.setSelection(selectedTags);
    }
  }, [selectedTags]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.name', {
      defaultMessage: 'Name'
    }),
    sortable: tag => tag.name,
    'data-test-subj': 'tagsTableRowName',
    render: (name, tag) => {
      return /*#__PURE__*/_react.default.createElement(_components.TagBadge, {
        tag: tag
      });
    }
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    'data-test-subj': 'tagsTableRowDescription'
  }, {
    field: 'relationCount',
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.connections', {
      defaultMessage: 'Connections'
    }),
    sortable: tag => tag.relationCount,
    'data-test-subj': 'tagsTableRowConnections',
    render: (relationCount, tag) => {
      if (relationCount < 1) {
        return undefined;
      }
      const columnText = /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tagsTableRowConnectionsText"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.savedObjectsTagging.management.table.content.connectionCount",
        defaultMessage: "{relationCount, plural, one {1 saved object} other {# saved objects}}",
        values: {
          relationCount
        }
      }));
      return capabilities.viewConnections ?
      /*#__PURE__*/
      // eslint-disable-next-line @elastic/eui/href-or-on-click
      _react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "tagsTableRowConnectionsLink",
        href: getTagRelationUrl(tag),
        onClick: e => {
          if (!isModifiedOrPrevented(e) && e.button === 0) {
            e.preventDefault();
            onShowRelations(tag);
          }
        }
      }, columnText) : columnText;
    }
  }, ...(actions.length ? [{
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.actions', {
      defaultMessage: 'Actions'
    }),
    width: '100px',
    actions
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "tagsManagementTable",
    ref: tableRef,
    childrenBetween: actionBar,
    loading: loading,
    itemId: 'id',
    columns: columns,
    items: tags,
    pagination: tablePagination,
    sorting: sorting,
    tableCaption: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.caption', {
      defaultMessage: 'Tags'
    }),
    rowHeader: "name",
    selection: allowSelection ? {
      initialSelected: selectedTags,
      onSelectionChange
    } : undefined,
    search: {
      defaultQuery: initialQuery,
      onChange: ({
        query
      }) => {
        onQueryChange(query || undefined);
      },
      box: {
        'data-test-subj': 'tagsManagementSearchBar',
        incremental: true,
        schema: {
          fields: {
            name: {
              type: 'string'
            },
            description: {
              type: 'string'
            }
          }
        }
      }
    },
    rowProps: item => ({
      'data-test-subj': 'tagsTableRow'
    })
  });
};
exports.TagTable = TagTable;