"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyESResp = applyESResp;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _field_mapping = require("./field_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A given response of and ElasticSearch containing a plain saved object is applied to the given
 * savedObject
 */
async function applyESResp(resp, savedObject, config, dependencies) {
  var _config$mapping;
  const mapping = (0, _field_mapping.expandShorthand)((_config$mapping = config.mapping) !== null && _config$mapping !== void 0 ? _config$mapping : {});
  const savedObjectType = config.type || '';
  savedObject._source = (0, _lodash.cloneDeep)(resp._source);
  if (typeof resp.found === 'boolean' && !resp.found) {
    throw new _public.SavedObjectNotFound(savedObjectType, savedObject.id || '');
  }
  const meta = resp._source.kibanaSavedObjectMeta || {};
  delete resp._source.kibanaSavedObjectMeta;
  if (!config.indexPattern && savedObject._source.indexPattern) {
    config.indexPattern = savedObject._source.indexPattern;
    delete savedObject._source.indexPattern;
  }

  // assign the defaults to the response
  (0, _lodash.defaults)(savedObject._source, savedObject.defaults);

  // transform the source using _deserializers
  (0, _lodash.forOwn)(mapping, (fieldMapping, fieldName) => {
    if (fieldMapping._deserialize && typeof fieldName === 'string') {
      savedObject._source[fieldName] = fieldMapping._deserialize(savedObject._source[fieldName]);
    }
  });

  // Give obj all of the values in _source.fields
  (0, _lodash.assign)(savedObject, savedObject._source);
  savedObject.lastSavedTitle = savedObject.title;
  if (meta.searchSourceJSON) {
    try {
      let searchSourceValues = (0, _public2.parseSearchSourceJSON)(meta.searchSourceJSON);
      if (config.searchSource) {
        searchSourceValues = (0, _public2.injectSearchSourceReferences)(searchSourceValues, resp.references);
        savedObject.searchSource = await dependencies.search.searchSource.create(searchSourceValues);
      } else {
        savedObject.searchSourceFields = searchSourceValues;
      }
    } catch (error) {
      if (error.constructor.name === 'SavedObjectNotFound' && error.savedObjectType === 'index-pattern') {
        // if parsing the search source fails because the index pattern wasn't found,
        // remember the reference - this is required for error handling on legacy imports
        savedObject.unresolvedIndexPatternReference = {
          name: 'kibanaSavedObjectMeta.searchSourceJSON.index',
          id: JSON.parse(meta.searchSourceJSON).index,
          type: 'index-pattern'
        };
      }
      throw error;
    }
  }
  const injectReferences = config.injectReferences;
  if (injectReferences && resp.references && resp.references.length > 0) {
    injectReferences(savedObject, resp.references);
  }
  if (typeof config.afterESResp === 'function') {
    savedObject = await config.afterESResp(savedObject);
  }
  return savedObject;
}