"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./index.scss");
var _saved_object = require("./saved_object");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedObjectsPublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "decoratorRegistry", new _saved_object.SavedObjectDecoratorRegistry());
  }
  setup() {
    return {
      registerDecorator: config => this.decoratorRegistry.register(config)
    };
  }
  start(core, {
    data,
    dataViews
  }) {
    (0, _kibana_services.setStartServices)(core);
    return {
      SavedObjectClass: (0, _saved_object.createSavedObjectClass)({
        dataViews,
        savedObjectsClient: core.savedObjects.client,
        search: data.search,
        chrome: core.chrome,
        overlays: core.overlays
      }, this.decoratorRegistry)
    };
  }
}
exports.SavedObjectsPublicPlugin = SavedObjectsPublicPlugin;