"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRollupJobsStore = createRollupJobsStore;
exports.rollupJobsStore = void 0;
var _redux = require("redux");
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _reducers = require("./reducers");
var _middleware = require("./middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createRollupJobsStore(initialState = {}) {
  const enhancers = [(0, _redux.applyMiddleware)(_reduxThunk.default, _middleware.detailPanel, _middleware.cloneJob)];
  window.__REDUX_DEVTOOLS_EXTENSION__ && enhancers.push(window.__REDUX_DEVTOOLS_EXTENSION__());
  return (0, _redux.createStore)(_reducers.rollupJobs, initialState, (0, _redux.compose)(...enhancers));
}
const rollupJobsStore = createRollupJobsStore();
exports.rollupJobsStore = rollupJobsStore;