"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTaskFnFactory = void 0;
var _generateCsv = require("@kbn/generate-csv");
var _services = require("../../services");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runTaskFnFactory = (reporting, _logger) => {
  const config = reporting.getConfig();
  const {
    encryptionKey,
    csv: csvConfig
  } = config;
  return async function runTask(jobId, job, cancellationToken, stream) {
    const logger = _logger.get(`execute:${jobId}`);
    const headers = await (0, _common.decryptJobHeaders)(encryptionKey, job.headers, logger);
    const fakeRequest = reporting.getFakeRequest(headers, job.spaceId, logger);
    const uiSettings = await reporting.getUiSettingsClient(fakeRequest, logger);
    const fieldFormatsRegistry = await (0, _services.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
    const {
      data: dataPluginStart,
      discover: discoverPluginStart
    } = await reporting.getPluginStartDeps();
    const data = dataPluginStart.search.asScoped(fakeRequest);
    const {
      locatorParams
    } = job;
    const {
      params
    } = locatorParams[0];

    // use Discover contract to convert the job params into inputs for CsvGenerator
    const locatorClient = await discoverPluginStart.locator.asScopedClient(fakeRequest);
    const columns = await locatorClient.columnsFromLocator(params);
    const searchSource = await locatorClient.searchSourceFromLocator(params);
    const [es, searchSourceStart] = await Promise.all([(await reporting.getEsClient()).asScoped(fakeRequest), await dataPluginStart.search.searchSource.asScoped(fakeRequest)]);
    const clients = {
      uiSettings,
      data,
      es
    };
    const dependencies = {
      searchSourceStart,
      fieldFormatsRegistry
    };
    const csv = new _generateCsv.CsvGenerator({
      columns,
      searchSource: searchSource.getSerializedFields(true),
      ...job
    }, csvConfig, clients, dependencies, cancellationToken, logger, stream);
    return await csv.generateData();
  };
};
exports.runTaskFnFactory = runTaskFnFactory;