"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFullRedirectAppUrl = getFullRedirectAppUrl;
var _url = require("url");
var _build_kibana_path = require("../../../../common/build_kibana_path");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFullRedirectAppUrl(config, serverInfo, spaceId, forceNow) {
  const {
    kibanaServer: {
      protocol,
      hostname,
      port
    }
  } = config;
  const path = (0, _build_kibana_path.buildKibanaPath)({
    basePath: serverInfo.basePath,
    spaceId,
    appPath: (0, _constants.getRedirectAppPath)()
  });
  return (0, _url.format)({
    protocol: protocol !== null && protocol !== void 0 ? protocol : serverInfo.protocol,
    hostname: hostname !== null && hostname !== void 0 ? hostname : serverInfo.hostname,
    port: port !== null && port !== void 0 ? port : serverInfo.port,
    pathname: path,
    query: forceNow ? {
      forceNow
    } : undefined
  });
}