"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailureToast = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var errors = _interopRequireWildcard(require("@kbn/reporting-common/errors"));
var _shared_i18n_texts = require("../shared_i18n_texts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFailureToast = (errorText, job, getManagmenetLink, theme, docLinks) => {
  return {
    title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.couldNotCreateReportTitle",
      defaultMessage: "Cannot create {reportType} report for '{reportObjectTitle}'.",
      values: {
        reportType: job.jobtype,
        reportObjectTitle: job.title
      }
    }), {
      theme$: theme.theme$
    }),
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "danger",
      "data-test-errorText": errorText
    }, job.errorCode === errors.VisualReportingSoftDisabledError.code ? _shared_i18n_texts.sharedI18nTexts.cloud.insufficientMemoryError(docLinks.links.reporting.cloudMinimumRequirements) : errorText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.checkManagement",
      defaultMessage: "Go to {path} for details.",
      values: {
        path: /*#__PURE__*/_react.default.createElement("a", {
          href: getManagmenetLink()
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.reporting.publicNotifier.error.reportingSectionUrlLinkLabel",
          defaultMessage: "Stack Management > Kibana > Reporting"
        }))
      }
    }))), {
      theme$: theme.theme$
    }),
    iconType: undefined,
    'data-test-subj': 'completeReportFailure'
  };
};
exports.getFailureToast = getFailureToast;