"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRemoteClustersStore = createRemoteClustersStore;
exports.remoteClustersStore = void 0;
var _redux = require("redux");
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _reducers = require("./reducers");
var _middleware = require("./middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createRemoteClustersStore(initialState = {}) {
  const enhancers = [(0, _redux.applyMiddleware)(_reduxThunk.default, _middleware.detailPanel)];
  return (0, _redux.createStore)(_reducers.remoteClusters, initialState, (0, _redux.compose)(...enhancers));
}
const remoteClustersStore = createRemoteClustersStore();
exports.remoteClustersStore = remoteClustersStore;