"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRouter = getRouter;
exports.getUserHasLeftApp = getUserHasLeftApp;
exports.registerRouter = registerRouter;
exports.setUserHasLeftApp = setUserHasLeftApp;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file based on guidance from https://github.com/elastic/eui/blob/master/wiki/react-router.md
 */

let _userHasLeftApp = false;
function setUserHasLeftApp(userHasLeftApp) {
  _userHasLeftApp = userHasLeftApp;
}
function getUserHasLeftApp() {
  return _userHasLeftApp;
}
let router;
function registerRouter(reactRouter) {
  router = reactRouter;
}
function getRouter() {
  return router;
}