"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _plugin = require("./plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These properties are used to create both the Collector and the Symbolizer integrations
 * when Universal Profiling is initialized.
 * As of now Universal Profiling is only availble on Elastic Cloud, so
 * Elastic Cloud will be responsable of filling these properties up and pass it to Kibana.
 */
const packageInputSchema = _configSchema.schema.object({
  host: _configSchema.schema.maybe(_configSchema.schema.string()),
  tls_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  tls_supported_protocols: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  tls_certificate_path: _configSchema.schema.maybe(_configSchema.schema.string()),
  tls_key_path: _configSchema.schema.maybe(_configSchema.schema.string())
});
const configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  symbolizer: _configSchema.schema.maybe(packageInputSchema),
  collector: _configSchema.schema.maybe(packageInputSchema),
  elasticsearch: _configSchema.schema.conditional(_configSchema.schema.contextRef('dist'), _configSchema.schema.literal(true), _configSchema.schema.never(), _configSchema.schema.maybe(_configSchema.schema.object({
    hosts: _configSchema.schema.string(),
    username: _configSchema.schema.string(),
    password: _configSchema.schema.string()
  })))
});
// plugin config
const config = {
  schema: configSchema
};

//  This exports static code and TypeScript types,
//  as well as, Kibana Platform `plugin()` initializer.
exports.config = config;
function plugin(initializerContext) {
  return new _plugin.ProfilingPlugin(initializerContext);
}