"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServices = getServices;
var _common = require("../common");
var _flamegraph = require("../common/flamegraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getServices() {
  const paths = (0, _common.getRoutePaths)();
  return {
    fetchTopN: async ({
      http,
      type,
      timeFrom,
      timeTo,
      kuery
    }) => {
      const query = {
        timeFrom,
        timeTo,
        kuery
      };
      return await http.get(`${paths.TopN}/${type}`, {
        query
      });
    },
    fetchTopNFunctions: async ({
      http,
      timeFrom,
      timeTo,
      startIndex,
      endIndex,
      kuery
    }) => {
      const query = {
        timeFrom,
        timeTo,
        startIndex,
        endIndex,
        kuery
      };
      return await http.get(paths.TopNFunctions, {
        query
      });
    },
    fetchElasticFlamechart: async ({
      http,
      timeFrom,
      timeTo,
      kuery
    }) => {
      const query = {
        timeFrom,
        timeTo,
        kuery
      };
      const baseFlamegraph = await http.get(paths.Flamechart, {
        query
      });
      return (0, _flamegraph.createFlameGraph)(baseFlamegraph);
    },
    fetchHasSetup: async ({
      http
    }) => {
      const hasSetup = await http.get(paths.HasSetupESResources, {});
      return hasSetup;
    },
    postSetupResources: async ({
      http
    }) => {
      await http.post(paths.HasSetupESResources, {});
    },
    setupDataCollectionInstructions: async ({
      http
    }) => {
      const instructions = await http.get(paths.SetupDataCollectionInstructions, {});
      return instructions;
    }
  };
}