"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingRouter = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _functions = require("../../common/functions");
var _stack_traces = require("../../common/stack_traces");
var _normalization_menu = require("../components/normalization_menu");
var _redirect_to = require("../components/redirect_to");
var _flame_graphs_view = require("../views/flame_graphs_view");
var _functions2 = require("../views/functions");
var _differential_topn = require("../views/functions/differential_topn");
var _topn = require("../views/functions/topn");
var _no_data_view = require("../views/no_data_view");
var _stack_traces_view = require("../views/stack_traces_view");
var _route_breadcrumb = require("./route_breadcrumb");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
      title: _i18n.i18n.translate('xpack.profiling.breadcrumb.profiling', {
        defaultMessage: 'Universal Profiling'
      }),
      href: "/"
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    children: {
      '/add-data-instructions': {
        element: /*#__PURE__*/_react.default.createElement(_no_data_view.NoDataView, null),
        params: t.type({
          query: t.type({
            selectedTab: t.union([t.literal(_no_data_view.NoDataTabs.Binary), t.literal(_no_data_view.NoDataTabs.Deb), t.literal(_no_data_view.NoDataTabs.Docker), t.literal(_no_data_view.NoDataTabs.ElasticAgentIntegration), t.literal(_no_data_view.NoDataTabs.Kubernetes), t.literal(_no_data_view.NoDataTabs.RPM), t.literal(_no_data_view.NoDataTabs.Symbols)])
          })
        }),
        defaults: {
          query: {
            selectedTab: _no_data_view.NoDataTabs.Kubernetes
          }
        }
      },
      '/': {
        children: {
          '/stacktraces/{topNType}': {
            element: /*#__PURE__*/_react.default.createElement(_stack_traces_view.StackTracesView, null),
            params: t.type({
              path: t.type({
                topNType: t.union([t.literal(_stack_traces.TopNType.Containers), t.literal(_stack_traces.TopNType.Deployments), t.literal(_stack_traces.TopNType.Hosts), t.literal(_stack_traces.TopNType.Threads), t.literal(_stack_traces.TopNType.Traces)])
              }),
              query: t.type({
                displayAs: t.union([t.literal(_stack_traces.StackTracesDisplayOption.StackTraces), t.literal(_stack_traces.StackTracesDisplayOption.Percentage)]),
                limit: _ioTsUtils.toNumberRt
              })
            }),
            defaults: {
              query: {
                displayAs: _stack_traces.StackTracesDisplayOption.StackTraces,
                limit: '10'
              }
            }
          },
          '/stacktraces': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/threads"
            })
          },
          '/flamegraphs': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.flamegraphs', {
                defaultMessage: 'Flamegraphs'
              }),
              href: "/flamegraphs/flamegraph"
            }, /*#__PURE__*/_react.default.createElement(_flame_graphs_view.FlameGraphsView, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
            children: {
              '/flamegraphs/flamegraph': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.flamegraph', {
                    defaultMessage: 'Flamegraph'
                  }),
                  href: "/flamegraphs/flamegraph"
                }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))
              },
              '/flamegraphs/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFlamegraph', {
                    defaultMessage: 'Differential flamegraph'
                  }),
                  href: "/flamegraphs/differential"
                }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    comparisonMode: t.union([t.literal(_normalization_menu.ComparisonMode.Absolute), t.literal(_normalization_menu.ComparisonMode.Relative)])
                  }), t.partial({
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)]),
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt
                  })])
                }),
                defaults: {
                  query: {
                    comparisonMode: _normalization_menu.ComparisonMode.Absolute,
                    normalizationMode: _normalization_menu.NormalizationMode.Time
                  }
                }
              }
            }
          },
          '/functions': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.functions', {
                defaultMessage: 'Functions'
              }),
              href: "/functions/topn"
            }, /*#__PURE__*/_react.default.createElement(_functions2.FunctionsView, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
            params: t.type({
              query: t.type({
                sortField: _functions.topNFunctionSortFieldRt,
                sortDirection: t.union([t.literal('asc'), t.literal('desc')])
              })
            }),
            defaults: {
              query: {
                sortField: _functions.TopNFunctionSortField.Rank,
                sortDirection: 'asc'
              }
            },
            children: {
              '/functions/topn': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.topnFunctions', {
                    defaultMessage: 'Top N'
                  }),
                  href: "/functions/topn"
                }, /*#__PURE__*/_react.default.createElement(_topn.TopNFunctionsView, null))
              },
              '/functions/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFunctions', {
                    defaultMessage: 'Differential Top N'
                  }),
                  href: "/functions/differential"
                }, /*#__PURE__*/_react.default.createElement(_differential_topn.DifferentialTopNFunctionsView, null)),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)])
                  }), t.partial({
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt
                  })])
                }),
                defaults: {
                  query: {
                    comparisonRangeFrom: 'now-15m',
                    comparisonRangeTo: 'now',
                    comparisonKuery: '',
                    normalizationMode: _normalization_menu.NormalizationMode.Time
                  }
                }
              }
            }
          },
          '/': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/threads"
            })
          }
        },
        element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
        params: t.type({
          query: t.type({
            rangeFrom: t.string,
            rangeTo: t.string,
            kuery: t.string
          })
        }),
        defaults: {
          query: {
            kuery: ''
          }
        }
      }
    }
  }
};
const profilingRouter = (0, _typedReactRouterConfig.createRouter)(routes);
exports.profilingRouter = profilingRouter;