"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockProfilingDependenciesStorybook = MockProfilingDependenciesStorybook;
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _url_service = require("@kbn/share-plugin/common/url_service");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _profiling_dependencies_context = require("./profiling_dependencies_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const urlService = new _url_service.UrlService({
  navigate: async () => {},
  getUrl: async ({
    app,
    path
  }, {
    absolute
  }) => {
    return `${absolute ? 'http://localhost:8888' : ''}/app/${app}${path}`;
  },
  shortUrls: () => ({
    get: () => {}
  })
});
const locator = urlService.locators.create(new _public2.MlLocatorDefinition());
const mockPlugin = {
  ml: {
    locator
  },
  data: {
    query: {
      timefilter: {
        timefilter: {
          setTime: () => {},
          getTime: () => ({})
        }
      }
    }
  }
};
const mockCore = {
  application: {
    currentAppId$: new _rxjs.Observable(),
    getUrlForApp: appId => '',
    navigateToUrl: url => {}
  },
  chrome: {
    docTitle: {
      change: () => {}
    },
    setBreadcrumbs: () => {},
    setHelpExtension: () => {},
    setBadge: () => {}
  },
  docLinks: {
    DOC_LINK_VERSION: 'current',
    ELASTIC_WEBSITE_URL: 'https://www.elastic.co/',
    links: {
      observability: {
        guide: ''
      }
    }
  },
  http: {
    basePath: {
      prepend: path => `/basepath${path}`,
      get: () => '/basepath'
    }
  },
  i18n: {
    Context: ({
      children
    }) => children
  },
  notifications: {
    toasts: {
      addWarning: () => {},
      addDanger: () => {},
      add: () => {}
    }
  }
};
const mockProfilingDependenciesContext = {
  core: mockCore,
  plugins: mockPlugin
};
function MockProfilingDependenciesStorybook({
  children
}) {
  const KibanaReactContext = (0, _public.createKibanaReactContext)(mockProfilingDependenciesContext.core);
  return /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false
  }, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, null, /*#__PURE__*/_react.default.createElement(_profiling_dependencies_context.ProfilingDependenciesContextProvider
  // We should keep adding more stuff to the mock object as we need
  , {
    value: {
      start: mockProfilingDependenciesContext,
      setup: {},
      services: {}
    }
  }, children)));
}