"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModalDashboardSelector = SaveModalDashboardSelector;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _dashboard_picker = _interopRequireDefault(require("./dashboard_picker"));
require("./saved_object_save_modal_dashboard.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SaveModalDashboardSelector(props) {
  const {
    documentId,
    onSelectDashboard,
    canSaveByReference,
    setAddToLibrary,
    isAddToLibrarySelected,
    dashboardOption,
    onChange,
    copyOnSave
  } = props;
  const isDisabled = !copyOnSave && !!documentId;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationUtil.saveModalDashboard.addToDashboardLabel",
      defaultMessage: "Add to dashboard"
    }),
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    "data-test-subj": "add-to-dashboard-options"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'existing',
    id: "existing-dashboard-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.existingDashboardOptionLabel', {
      defaultMessage: 'Existing'
    }),
    onChange: () => onChange('existing'),
    disabled: isDisabled
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "savAddDashboard__searchDashboards"
  }, /*#__PURE__*/_react.default.createElement(_dashboard_picker.default, {
    isDisabled: dashboardOption !== 'existing',
    onChange: onSelectDashboard
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'new',
    id: "new-dashboard-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.newDashboardOptionLabel', {
      defaultMessage: 'New'
    }),
    onChange: () => onChange('new'),
    disabled: isDisabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === null,
    id: "add-to-library-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.noDashboardOptionLabel', {
      defaultMessage: 'None'
    }),
    onChange: () => {
      setAddToLibrary(true);
      onChange(null);
    },
    disabled: isDisabled || !canSaveByReference
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "add-to-library-checkbox"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "add-to-library-checkbox",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.libraryOptionLabel', {
      defaultMessage: 'Add to library'
    }),
    checked: isAddToLibrarySelected,
    disabled: dashboardOption === null || isDisabled || !canSaveByReference,
    onChange: event => setAddToLibrary(event.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "iInCircle",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationUtil.saveModalDashboard.dashboardInfoTooltip",
      defaultMessage: "items added to the Visualize Library are available to all dashboards. Edits to a library item appear everywhere it is used."
    })
  }))))));
}