"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeFilter = FieldTypeFilter;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _i18nReact = require("@kbn/i18n-react");
require("./field_type_filter.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FieldTypeFilter({
  onFieldTypesChange,
  fieldTypesValue,
  availableFieldTypes,
  buttonProps
}) {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handleFilterButtonClicked = () => {
    setPopoverOpen(!isPopoverOpen);
  };
  const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, buttonProps, {
    "data-test-subj": "toggleFieldFilterButton",
    iconType: "arrowDown",
    isSelected: fieldTypesValue.length > 0,
    numFilters: 0,
    hasActiveFilters: fieldTypesValue.length > 0,
    numActiveFilters: fieldTypesValue.length,
    onClick: handleFilterButtonClicked
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationUtil.fieldSearch.fieldFilterButtonLabel",
    defaultMessage: "Filter by type"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => {},
    isDisabled: !isPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: "euiFilterGroup__popoverPanel presFilterByType__panel",
    panelPaddingSize: "none",
    display: "block",
    isOpen: isPopoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
    },
    button: buttonContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('presentationUtil.fieldSearch.filterByTypeLabel', {
    defaultMessage: 'Filter by type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: availableFieldTypes.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: type,
      icon: fieldTypesValue.includes(type) ? 'check' : 'empty',
      "data-test-subj": `typeFilter-${type}`,
      onClick: () => {
        if (fieldTypesValue.includes(type)) {
          onFieldTypesChange(fieldTypesValue.filter(f => f !== type));
        } else {
          onFieldTypesChange([...fieldTypesValue, type]);
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: type,
      label: type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, type))))
  }))));
}