"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackFieldWrapper = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _use_packs = require("../../packs/use_packs");
var _packs_combobox_field = require("../../live_queries/form/packs_combobox_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackFieldWrapper = ({
  liveQueryDetails,
  submitButtonContent,
  showResultsHeader
}) => {
  var _liveQueryDetails$que, _selectedPackData$que, _liveQueryDetails$que2;
  const {
    data: packsData
  } = (0, _use_packs.usePacks)({});
  const {
    packId
  } = (0, _reactHookForm.useWatch)();
  const selectedPackData = (0, _react.useMemo)(() => packId !== null && packId !== void 0 && packId.length ? (0, _lodash.find)(packsData === null || packsData === void 0 ? void 0 : packsData.data, {
    saved_object_id: packId[0]
  }) : null, [packId, packsData]);
  const actionId = (0, _react.useMemo)(() => liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.action_id, [liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.action_id]);
  const agentIds = (0, _react.useMemo)(() => liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.agents, [liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.agents]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_packs_combobox_field.PacksComboBoxField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    fieldProps: {
      packsData: packsData === null || packsData === void 0 ? void 0 : packsData.data
    },
    queryType: "pack"
  })), submitButtonContent, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), liveQueryDetails !== null && liveQueryDetails !== void 0 && (_liveQueryDetails$que = liveQueryDetails.queries) !== null && _liveQueryDetails$que !== void 0 && _liveQueryDetails$que.length || selectedPackData !== null && selectedPackData !== void 0 && (_selectedPackData$que = selectedPackData.queries) !== null && _selectedPackData$que !== void 0 && _selectedPackData$que.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    agentIds: agentIds
    // @ts-expect-error update types
    ,
    data: (_liveQueryDetails$que2 = liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.queries) !== null && _liveQueryDetails$que2 !== void 0 ? _liveQueryDetails$que2 : selectedPackData === null || selectedPackData === void 0 ? void 0 : selectedPackData.queries,
    showResultsHeader: showResultsHeader
  })) : null);
};
exports.PackFieldWrapper = PackFieldWrapper;