"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueryForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _form = require("../../form");
var _platform_checkbox_group_field = require("../../packs/queries/platform_checkbox_group_field");
var _constants = require("../../packs/queries/constants");
var _lazy_ecs_mapping_editor_field = require("../../packs/queries/lazy_ecs_mapping_editor_field");
var _playground_flyout = require("./playground_flyout");
var _code_editor_field = require("./code_editor_field");
var _utils = require("../../packs/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedQueryFormComponent = ({
  viewMode,
  hasPlayground,
  isValid,
  idSet
}) => {
  const [playgroundVisible, setPlaygroundVisible] = (0, _react.useState)(false);
  const euiFieldProps = (0, _react.useMemo)(() => ({
    isDisabled: !!viewMode
  }), [viewMode]);
  const handleHidePlayground = (0, _react.useCallback)(() => setPlaygroundVisible(false), []);
  const handleTogglePlayground = (0, _react.useCallback)(() => setPlaygroundVisible(prevValue => !prevValue), []);
  const intervalEuiFieldProps = (0, _react.useMemo)(() => ({
    append: 's',
    ...euiFieldProps
  }), [euiFieldProps]);
  const versionEuiFieldProps = (0, _react.useMemo)(() => ({
    noSuggestions: false,
    singleSelection: {
      asPlainText: true
    },
    placeholder: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.osqueryVersionAllLabel', {
      defaultMessage: 'ALL'
    }),
    options: _constants.ALL_OSQUERY_VERSIONS_OPTIONS,
    onCreateOption: undefined,
    ...euiFieldProps
  }), [euiFieldProps]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.QueryIdField, {
    idSet: idSet,
    euiFieldProps: euiFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form.QueryDescriptionField, {
    euiFieldProps: euiFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_code_editor_field.CodeEditorField, {
    euiFieldProps: euiFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss
  }, /*#__PURE__*/_react.default.createElement(_lazy_ecs_mapping_editor_field.ECSMappingEditorField, {
    euiFieldProps: euiFieldProps
  }))), !viewMode && hasPlayground && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "play",
    onClick: handleTogglePlayground
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQueries.form.packConfigSection.testConfigButtonLabel",
    defaultMessage: "Test configuration"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQueries.form.packConfigSection.title",
    defaultMessage: "Pack configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQueries.form.packConfigSection.description",
    defaultMessage: "The options listed below are optional and are only applied when the query is assigned to a pack."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_form.IntervalField, {
    euiFieldProps: intervalEuiFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form.VersionField, {
    euiFieldProps: versionEuiFieldProps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form.ResultsTypeField, {
    euiFieldProps: euiFieldProps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_platform_checkbox_group_field.PlatformCheckBoxGroupField, {
    euiFieldProps: euiFieldProps
  }))), playgroundVisible && /*#__PURE__*/_react.default.createElement(_playground_flyout.PlaygroundFlyout, {
    enabled: isValid !== undefined ? isValid : true,
    onClose: handleHidePlayground
  }));
};
SavedQueryFormComponent.displayName = 'SavedQueryForm';
const SavedQueryForm = /*#__PURE__*/_react.default.memo(SavedQueryFormComponent);
exports.SavedQueryForm = SavedQueryForm;