"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadIntegrationAssetsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_import_assets = require("../../../assets/use_import_assets");
var _use_assets_status = require("../../../assets/use_assets_status");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadIntegrationAssetsButtonComponent = ({
  fill
}) => {
  var _data$upToDate;
  const {
    data
  } = (0, _use_assets_status.useAssetsStatus)();
  const {
    isLoading,
    mutateAsync
  } = (0, _use_import_assets.useImportAssets)({
    successToastText: data !== null && data !== void 0 && (_data$upToDate = data.upToDate) !== null && _data$upToDate !== void 0 && _data$upToDate.length ? _translations.UPDATE_PREBUILT_PACKS_SUCCESS_TEXT : _translations.LOAD_PREBUILT_PACKS_SUCCESS_TEXT
  });
  const handleClick = (0, _react.useCallback)(() => mutateAsync(), [mutateAsync]);
  if (data !== null && data !== void 0 && data.install.length || data !== null && data !== void 0 && data.update.length) {
    var _data$upToDate2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: !!fill,
      isLoading: isLoading,
      onClick: handleClick,
      iconType: "plusInCircle"
    }, data !== null && data !== void 0 && (_data$upToDate2 = data.upToDate) !== null && _data$upToDate2 !== void 0 && _data$upToDate2.length ? _translations.UPDATE_PREBUILT_PACKS_BUTTON : _translations.LOAD_PREBUILT_PACKS_BUTTON);
  }
  return null;
};
const LoadIntegrationAssetsButton = /*#__PURE__*/_react.default.memo(LoadIntegrationAssetsButtonComponent);
exports.LoadIntegrationAssetsButton = LoadIntegrationAssetsButton;