"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQueries = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _list = require("./list");
var _new = require("./new");
var _details = require("./details");
var _use_breadcrumbs = require("../../common/hooks/use_breadcrumbs");
var _kibana = require("../../common/lib/kibana");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LiveQueriesComponent = () => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  (0, _use_breadcrumbs.useBreadcrumbs)('live_queries');
  const match = (0, _reactRouterDom.useRouteMatch)();
  if (!permissions.readLiveQueries) {
    return /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, null);
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/new`
  }, permissions.runSavedQueries && (permissions.readSavedQueries || permissions.readPacks) || permissions.writeLiveQueries ? /*#__PURE__*/_react.default.createElement(_new.NewLiveQueryPage, null) : /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/:actionId`
  }, /*#__PURE__*/_react.default.createElement(_details.LiveQueryDetailsPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}`
  }, /*#__PURE__*/_react.default.createElement(_list.LiveQueriesPage, null)));
};
const LiveQueries = /*#__PURE__*/_react.default.memo(LiveQueriesComponent);
exports.LiveQueries = LiveQueries;