"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyIdComboBoxField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _agent_policies = require("../../agent_policies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Custom styling for drop down list items due to:
//  1) the max-width and overflow properties is added to prevent long agent policy
//     names/descriptions from overflowing the flex items
//  2) max-width is built from the grow property on the flex items because the value
//     changes based on if Fleet is enabled/setup or not
const AgentPolicyNameColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: ${props => `${props.grow / 9 * 100}%`};
  overflow: hidden;
`;
const AgentPolicyDescriptionColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: ${props => `${props.grow / 9 * 100}%`};
  overflow: hidden;
`;
const PolicyIdComboBoxFieldComponent = ({
  euiFieldProps,
  options
}) => {
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'policy_ids',
    defaultValue: [],
    rules: {}
  });
  const selectedOptions = (0, _react.useMemo)(() => {
    if (agentPoliciesById) {
      return (0, _lodash.castArray)(value).map(policyId => {
        var _agentPoliciesById$po, _agentPoliciesById$po2;
        return {
          key: policyId,
          label: (_agentPoliciesById$po = (_agentPoliciesById$po2 = agentPoliciesById[policyId]) === null || _agentPoliciesById$po2 === void 0 ? void 0 : _agentPoliciesById$po2.name) !== null && _agentPoliciesById$po !== void 0 ? _agentPoliciesById$po : policyId
        };
      });
    }
    return [];
  }, [agentPoliciesById, value]);
  const handleChange = (0, _react.useCallback)(newOptions => {
    onChange(newOptions.map(option => option.key || option.label));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)(option => {
    var _ref, _agentPoliciesById$op, _ref2, _ref3, _agentPoliciesById$op2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(AgentPolicyNameColumn, {
      grow: 2
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate"
    }, (_ref = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : (_agentPoliciesById$op = agentPoliciesById[option.key]) === null || _agentPoliciesById$op === void 0 ? void 0 : _agentPoliciesById$op.name)) !== null && _ref !== void 0 ? _ref : option.label)), /*#__PURE__*/_react.default.createElement(AgentPolicyDescriptionColumn, {
      grow: 5
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      className: "eui-textTruncate",
      color: "subdued"
    }, (_ref2 = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : agentPoliciesById[option.key].description)) !== null && _ref2 !== void 0 ? _ref2 : '')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 2,
      className: "eui-textRight"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.createScheduledQuery.agentPolicyAgentsCountText",
      defaultMessage: "{count, plural, one {# agent} other {# agents}} enrolled"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        count: (_ref3 = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : (_agentPoliciesById$op2 = agentPoliciesById[option.key]) === null || _agentPoliciesById$op2 === void 0 ? void 0 : _agentPoliciesById$op2.agents)) !== null && _ref3 !== void 0 ? _ref3 : 0
      }
    }))));
  }, [agentPoliciesById]);
  const helpText = (0, _react.useMemo)(() => {
    if (!(value !== null && value !== void 0 && value.length) || !value[0].length || !agentPoliciesById) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.pack.form.agentPoliciesFieldHelpText",
        defaultMessage: "Queries in this pack are scheduled for agents in the selected policies."
      });
    }
    const agentCount = (0, _lodash.reduce)(value, (acc, policyId) => {
      var _agentPolicy$agents;
      const agentPolicy = agentPoliciesById && agentPoliciesById[policyId];
      return acc + ((_agentPolicy$agents = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0);
    }, 0);
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.createScheduledQuery.agentPolicyAgentsCountText",
      defaultMessage: "{count, plural, one {# agent} other {# agents}} enrolled"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        count: agentCount
      }
    });
  }, [agentPoliciesById, value]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.pack.form.agentPoliciesFieldLabel', {
      defaultMessage: 'Scheduled agent policies (optional)'
    }),
    helpText: helpText,
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: hasError,
    selectedOptions: selectedOptions,
    fullWidth: true,
    "data-test-subj": "policyIdsComboBox",
    isClearable: true,
    options: options,
    renderOption: renderOption,
    onChange: handleChange
  }, euiFieldProps)));
};
const PolicyIdComboBoxField = /*#__PURE__*/_react.default.memo(PolicyIdComboBoxFieldComponent, _fastDeepEqual.default);
exports.PolicyIdComboBoxField = PolicyIdComboBoxField;