"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigUploader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_CONFIG_EXTENSIONS = ['application/json', 'text/plain'];
const ExampleConfigLink = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: "https://github.com/osquery/osquery/blob/master/tools/deployment/osquery.example.conf",
  target: "_blank"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.osquery.configUploader.exampleConfigLinkLabel",
  defaultMessage: "Example config"
})));
ExampleConfigLink.displayName = 'ExampleOsqueryConfigLink';
const ConfigUploaderComponent = ({
  onChange
}) => {
  const filePickerRef = (0, _react.useRef)(null);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(null);
  // @ts-expect-error update types
  let fileReader;
  const handleFileRead = () => {
    var _filePickerRef$curren2;
    // @ts-expect-error update types
    const content = fileReader.result;
    let parsedContent;
    try {
      parsedContent = JSON.parse(content.replaceAll('\\\n', ''), (key, value) => {
        if (key === 'query') {
          // remove any multiple spaces from the query
          return value.replaceAll(/\s(?=\s)/gm, '');
        }
        return value;
      });
      setIsInvalid(null);
    } catch (error) {
      var _filePickerRef$curren;
      setIsInvalid(error);
      // @ts-expect-error update types
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles(new Event('fake'));
    }
    onChange(parsedContent);
    // @ts-expect-error update types
    (_filePickerRef$curren2 = filePickerRef.current) === null || _filePickerRef$curren2 === void 0 ? void 0 : _filePickerRef$curren2.removeFiles(new Event('fake'));
  };

  // @ts-expect-error update types
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const handleFileChosen = file => {
    fileReader = new FileReader();
    fileReader.onloadend = handleFileRead;
    fileReader.readAsText(file);
  };
  const handleInputChange = (0, _react.useCallback)(inputFiles => {
    var _ref;
    if (!inputFiles.length) {
      return;
    }
    if (inputFiles.length && ((_ref = !!inputFiles[0].type.length && !SUPPORTED_CONFIG_EXTENSIONS.includes(inputFiles[0].type)) !== null && _ref !== void 0 ? _ref : !inputFiles[0].name.endsWith('.conf'))) {
      var _filePickerRef$curren3;
      setIsInvalid(_i18n.i18n.translate('xpack.osquery.configUploader.unsupportedFileTypeText', {
        defaultMessage: 'File type {fileType} is not supported, please upload {supportedFileTypes} config file',
        values: {
          fileType: inputFiles[0].type,
          supportedFileTypes: SUPPORTED_CONFIG_EXTENSIONS.join(' or ')
        }
      }));
      // @ts-expect-error update types
      (_filePickerRef$curren3 = filePickerRef.current) === null || _filePickerRef$curren3 === void 0 ? void 0 : _filePickerRef$curren3.removeFiles(new Event('fake'));
      return;
    }
    handleFileChosen(inputFiles[0]);
  }, [handleFileChosen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(ExampleConfigLink, null),
    isInvalid: !!isInvalid,
    error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${isInvalid}`)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    ref: filePickerRef,
    id: "osquery_config_picker",
    initialPromptText: _i18n.i18n.translate('xpack.osquery.configUploader.initialPromptTextLabel', {
      defaultMessage: 'Select or drag and drop osquery config file'
    }),
    onChange: handleInputChange,
    display: "large",
    fullWidth: true,
    isInvalid: !!isInvalid,
    accept: SUPPORTED_CONFIG_EXTENSIONS.join(',')
  })));
};
const ConfigUploader = /*#__PURE__*/_react.default.memo(ConfigUploaderComponent);
exports.ConfigUploader = ConfigUploader;