"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// copied from x-pack/plugins/fleet/public/applications/fleet/components/header.tsx

const Container = _styledComponents.default.div`
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  background-color: ${props => props.theme.eui.euiPageBackgroundColor};
`;
const Wrapper = _styledComponents.default.div`
  max-width: ${props => props.maxWidth || 1200}px;
  margin-left: auto;
  margin-right: auto;
  padding-top: ${props => props.theme.eui.euiSizeXL};
  padding-left: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
`;
const Tabs = (0, _styledComponents.default)(_eui.EuiTabs)`
  top: 1px;
  &:before {
    height: 0px;
  }
`;
const HeaderColumns = /*#__PURE__*/(0, _react.memo)(({
  leftColumn,
  rightColumn,
  rightColumnGrow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, leftColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, leftColumn) : null, rightColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: rightColumnGrow
}, rightColumn) : null));
HeaderColumns.displayName = 'HeaderColumns';
const HeaderComponent = ({
  children,
  leftColumn,
  rightColumn,
  rightColumnGrow,
  tabs,
  maxWidth,
  tabsClassName,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(Container, {
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(Wrapper, {
  maxWidth: maxWidth
}, /*#__PURE__*/_react.default.createElement(HeaderColumns, {
  leftColumn: leftColumn,
  rightColumn: rightColumn,
  rightColumnGrow: rightColumnGrow
}), children, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, tabs ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(Tabs, {
  className: tabsClassName
}, tabs.map(props => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, props, {
  key: props.id
}), props.name)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
})))));
const Header = /*#__PURE__*/_react.default.memo(HeaderComponent);
exports.Header = Header;