"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionResults = void 0;
var _fp = require("lodash/fp");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _helpers = require("../common/helpers");
var _kibana = require("../common/lib/kibana");
var _search_strategy = require("../../common/search_strategy");
var _query_client = require("../query_client");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActionResults = ({
  actionId,
  activePage,
  agentIds,
  direction,
  limit,
  sortField,
  filterQuery,
  skip = false,
  isLive = false
}) => {
  var _agentIds$length;
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['actionResults', {
    actionId
  }], async () => {
    var _responseData$rawResp, _responseData$rawResp2, _responseData$rawResp3, _responseData$rawResp4, _responseData$rawResp5, _responseData$rawResp6, _responseData$rawResp7, _responseData$rawResp8, _responseData$rawResp9, _responseData$rawResp10, _responseData$rawResp11, _responseData$rawResp12, _agentIds$map, _aggsBuckets$find$doc, _aggsBuckets$find, _aggsBuckets$find$doc2, _aggsBuckets$find2;
    const responseData = await (0, _rxjs.lastValueFrom)(data.search.search({
      actionId,
      factoryQueryType: _search_strategy.OsqueryQueries.actionResults,
      filterQuery: (0, _helpers.createFilter)(filterQuery),
      pagination: (0, _helpers.generateTablePaginationOptions)(activePage, limit),
      sort: {
        direction,
        field: sortField
      }
    }, {
      strategy: 'osquerySearchStrategy'
    }));
    const totalResponded = (_responseData$rawResp = (_responseData$rawResp2 = responseData.rawResponse) === null || _responseData$rawResp2 === void 0 ? void 0 : (_responseData$rawResp3 = _responseData$rawResp2.aggregations) === null || _responseData$rawResp3 === void 0 ? void 0 : (_responseData$rawResp4 = _responseData$rawResp3.aggs.responses_by_action_id) === null || _responseData$rawResp4 === void 0 ? void 0 : _responseData$rawResp4.doc_count) !== null && _responseData$rawResp !== void 0 ? _responseData$rawResp : 0;
    const totalRowCount = (_responseData$rawResp5 = (_responseData$rawResp6 = responseData.rawResponse) === null || _responseData$rawResp6 === void 0 ? void 0 : (_responseData$rawResp7 = _responseData$rawResp6.aggregations) === null || _responseData$rawResp7 === void 0 ? void 0 : (_responseData$rawResp8 = _responseData$rawResp7.aggs.responses_by_action_id) === null || _responseData$rawResp8 === void 0 ? void 0 : (_responseData$rawResp9 = _responseData$rawResp8.rows_count) === null || _responseData$rawResp9 === void 0 ? void 0 : _responseData$rawResp9.value) !== null && _responseData$rawResp5 !== void 0 ? _responseData$rawResp5 : 0;
    const aggsBuckets = (_responseData$rawResp10 = responseData.rawResponse) === null || _responseData$rawResp10 === void 0 ? void 0 : (_responseData$rawResp11 = _responseData$rawResp10.aggregations) === null || _responseData$rawResp11 === void 0 ? void 0 : (_responseData$rawResp12 = _responseData$rawResp11.aggs.responses_by_action_id) === null || _responseData$rawResp12 === void 0 ? void 0 : _responseData$rawResp12.responses.buckets;
    const cachedData = _query_client.queryClient.getQueryData(['actionResults', {
      actionId
    }]);
    const previousEdges = cachedData !== null && cachedData !== void 0 && cachedData.edges.length ? cachedData === null || cachedData === void 0 ? void 0 : cachedData.edges : (_agentIds$map = agentIds === null || agentIds === void 0 ? void 0 : agentIds.map(agentId => ({
      fields: {
        agent_id: [agentId]
      }
    }))) !== null && _agentIds$map !== void 0 ? _agentIds$map : [];
    return {
      ...responseData,
      edges: (0, _fp.reverse)((0, _fp.uniqBy)('fields.agent_id[0]', (0, _fp.flatten)([responseData.edges, previousEdges]))),
      aggregations: {
        totalRowCount,
        totalResponded,
        successful: (_aggsBuckets$find$doc = aggsBuckets === null || aggsBuckets === void 0 ? void 0 : (_aggsBuckets$find = aggsBuckets.find(bucket => bucket.key === 'success')) === null || _aggsBuckets$find === void 0 ? void 0 : _aggsBuckets$find.doc_count) !== null && _aggsBuckets$find$doc !== void 0 ? _aggsBuckets$find$doc : 0,
        failed: (_aggsBuckets$find$doc2 = aggsBuckets === null || aggsBuckets === void 0 ? void 0 : (_aggsBuckets$find2 = aggsBuckets.find(bucket => bucket.key === 'error')) === null || _aggsBuckets$find2 === void 0 ? void 0 : _aggsBuckets$find2.doc_count) !== null && _aggsBuckets$find$doc2 !== void 0 ? _aggsBuckets$find$doc2 : 0
      },
      inspect: (0, _helpers.getInspectResponse)(responseData, {})
    };
  }, {
    initialData: {
      edges: [],
      aggregations: {
        totalResponded: 0,
        successful: 0,
        pending: (_agentIds$length = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length !== void 0 ? _agentIds$length : 0,
        failed: 0
      }
    },
    refetchInterval: isLive ? 5000 : false,
    keepPreviousData: true,
    enabled: !skip && !!(agentIds !== null && agentIds !== void 0 && agentIds.length),
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.action_results.fetchError', {
        defaultMessage: 'Error while fetching action results'
      })
    })
  });
};
exports.useActionResults = useActionResults;