"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetPreviewData = void 0;
var _esQuery = require("@kbn/es-query");
var _services = require("../../domain/services");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetPreviewData {
  constructor(esClient) {
    this.esClient = esClient;
  }
  async execute(params) {
    switch (params.indicator.type) {
      case 'sli.kql.custom':
        const filterQuery = getElastichsearchQueryOrThrow(params.indicator.params.filter);
        const goodQuery = getElastichsearchQueryOrThrow(params.indicator.params.good);
        const totalQuery = getElastichsearchQueryOrThrow(params.indicator.params.total);
        const timestampField = params.indicator.params.timestampField;
        try {
          var _result$aggregations;
          const result = await this.esClient.search({
            index: params.indicator.params.index,
            query: {
              bool: {
                filter: [{
                  range: {
                    [timestampField]: {
                      gte: 'now-60m'
                    }
                  }
                }, filterQuery]
              }
            },
            aggs: {
              perMinute: {
                date_histogram: {
                  field: timestampField,
                  fixed_interval: '1m'
                },
                aggs: {
                  good: {
                    filter: goodQuery
                  },
                  total: {
                    filter: totalQuery
                  }
                }
              }
            }
          });

          // @ts-ignore buckets is not improperly typed
          return (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.perMinute.buckets.map(bucket => ({
            date: bucket.key_as_string,
            sliValue: (0, _services.computeSLI)(bucket.good.doc_count, bucket.total.doc_count)
          }));
        } catch (err) {
          throw new _errors.InvalidQueryError(`Invalid ES query`);
        }
      default:
        return [];
    }
  }
}
exports.GetPreviewData = GetPreviewData;
function getElastichsearchQueryOrThrow(kuery) {
  try {
    return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery));
  } catch (err) {
    throw new _errors.InvalidQueryError(`Invalid kuery: ${kuery}`);
  }
}