"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalDiagnosis = getGlobalDiagnosis;
exports.getSloDiagnosis = getSloDiagnosis;
var _constants = require("../../assets/constants");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OK = 'OK';
const NOT_OK = 'NOT_OK';
async function getGlobalDiagnosis(esClient, licensing) {
  try {
    const licenseInfo = licensing.license.toJSON();
    const userPrivileges = await esClient.security.getUserPrivileges();
    const sloResources = await getSloResourcesDiagnosis(esClient);
    return {
      licenseAndFeatures: licenseInfo,
      userPrivileges,
      sloResources
    };
  } catch (error) {
    throw error;
  }
}
async function getSloDiagnosis(sloId, services) {
  var _sloSavedObject$attri, _sloSavedObject, _sloSavedObject2, _sloSavedObject3, _dataSample;
  const {
    esClient,
    soClient
  } = services;
  const sloResources = await getSloResourcesDiagnosis(esClient);
  let sloSavedObject;
  try {
    sloSavedObject = await soClient.get(_saved_objects.SO_SLO_TYPE, sloId);
  } catch (err) {
    // noop
  }
  const sloTransformStats = await esClient.transform.getTransformStats({
    transform_id: (0, _constants.getSLOTransformId)(sloId, (_sloSavedObject$attri = (_sloSavedObject = sloSavedObject) === null || _sloSavedObject === void 0 ? void 0 : _sloSavedObject.attributes.revision) !== null && _sloSavedObject$attri !== void 0 ? _sloSavedObject$attri : 1)
  });
  let dataSample;
  if ((_sloSavedObject2 = sloSavedObject) !== null && _sloSavedObject2 !== void 0 && _sloSavedObject2.attributes.indicator.params.index) {
    var _slo$indicator$params;
    const slo = sloSavedObject.attributes;
    const sortField = 'timestampField' in slo.indicator.params ? (_slo$indicator$params = slo.indicator.params.timestampField) !== null && _slo$indicator$params !== void 0 ? _slo$indicator$params : '@timestamp' : '@timestamp';
    dataSample = await esClient.search({
      index: slo.indicator.params.index,
      sort: {
        [sortField]: 'desc'
      },
      size: 5
    });
  }
  return {
    sloResources,
    sloSavedObject: (_sloSavedObject3 = sloSavedObject) !== null && _sloSavedObject3 !== void 0 ? _sloSavedObject3 : NOT_OK,
    sloTransformStats,
    dataSample: (_dataSample = dataSample) !== null && _dataSample !== void 0 ? _dataSample : NOT_OK
  };
}
async function getSloResourcesDiagnosis(esClient) {
  try {
    const indexTemplateExists = await esClient.indices.existsIndexTemplate({
      name: _constants.SLO_INDEX_TEMPLATE_NAME
    });
    const mappingsTemplateExists = await esClient.cluster.existsComponentTemplate({
      name: _constants.SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME
    });
    const settingsTemplateExists = await esClient.cluster.existsComponentTemplate({
      name: _constants.SLO_COMPONENT_TEMPLATE_SETTINGS_NAME
    });
    let ingestPipelineExists = true;
    try {
      await esClient.ingest.getPipeline({
        id: _constants.SLO_INGEST_PIPELINE_NAME
      });
    } catch (err) {
      ingestPipelineExists = false;
      throw err;
    }
    return {
      [_constants.SLO_INDEX_TEMPLATE_NAME]: indexTemplateExists ? OK : NOT_OK,
      [_constants.SLO_COMPONENT_TEMPLATE_MAPPINGS_NAME]: mappingsTemplateExists ? OK : NOT_OK,
      [_constants.SLO_COMPONENT_TEMPLATE_SETTINGS_NAME]: settingsTemplateExists ? OK : NOT_OK,
      [_constants.SLO_INGEST_PIPELINE_NAME]: ingestPipelineExists ? OK : NOT_OK
    };
  } catch (err) {
    if (err.meta.statusCode === 403) {
      throw new Error('Insufficient permissions to access Elasticsearch Cluster', {
        cause: err
      });
    }
  }
}