"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBurnRates = getBurnRates;
var _slo_repository = require("./slo_repository");
var _sli_client = require("./sli_client");
var _services = require("../../domain/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getBurnRates(sloId, windows, services) {
  const {
    soClient,
    esClient
  } = services;
  const repository = new _slo_repository.KibanaSavedObjectsSLORepository(soClient);
  const sliClient = new _sli_client.DefaultSLIClient(esClient);
  const slo = await repository.findById(sloId);
  const sliData = await sliClient.fetchSLIDataFrom(slo, windows);
  return Object.keys(sliData).map(key => {
    return {
      name: key,
      burnRate: (0, _services.computeBurnRate)(slo, sliData[key]),
      sli: (0, _services.computeSLI)(sliData[key].good, sliData[key].total)
    };
  });
}