"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _slo_repository = require("./slo_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1;
const DEFAULT_PER_PAGE = 25;
class FindSLO {
  constructor(repository, summaryClient) {
    this.repository = repository;
    this.summaryClient = summaryClient;
  }
  async execute(params) {
    const pagination = toPagination(params);
    const criteria = toCriteria(params);
    const sort = toSort(params);
    const {
      results: sloList,
      ...resultMeta
    } = await this.repository.find(criteria, sort, pagination);
    const summaryBySlo = await this.summaryClient.fetchSummary(sloList);
    const sloListWithSummary = mergeSloWithSummary(sloList, summaryBySlo);
    return _sloSchema.findSLOResponseSchema.encode({
      page: resultMeta.page,
      perPage: resultMeta.perPage,
      total: resultMeta.total,
      results: sloListWithSummary
    });
  }
}
exports.FindSLO = FindSLO;
function mergeSloWithSummary(sloList, summaryBySlo) {
  return sloList.map(slo => ({
    ...slo,
    summary: summaryBySlo[slo.id]
  }));
}
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : DEFAULT_PER_PAGE
  };
}
function toCriteria(params) {
  return {
    name: params.name,
    indicatorTypes: params.indicatorTypes
  };
}
function toSort(params) {
  return {
    field: params.sortBy === 'indicatorType' ? _slo_repository.SortField.IndicatorType : _slo_repository.SortField.CreationTime,
    direction: params.sortDirection === 'desc' ? _slo_repository.SortDirection.Desc : _slo_repository.SortDirection.Asc
  };
}