"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FetchHistoricalSummary = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FetchHistoricalSummary {
  constructor(repository, historicalSummaryClient) {
    this.repository = repository;
    this.historicalSummaryClient = historicalSummaryClient;
  }
  async execute({
    sloIds
  }) {
    const sloList = await this.repository.findAllByIds(sloIds);
    const historicalSummaryBySlo = await this.historicalSummaryClient.fetch(sloList);
    return _sloSchema.fetchHistoricalSummaryResponseSchema.encode(historicalSummaryBySlo);
  }
}
exports.FetchHistoricalSummary = FetchHistoricalSummary;