"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compositeSlo = exports.SO_COMPOSITE_SLO_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_COMPOSITE_SLO_TYPE = 'composite-slo';
exports.SO_COMPOSITE_SLO_TYPE = SO_COMPOSITE_SLO_TYPE;
const compositeSlo = {
  name: SO_COMPOSITE_SLO_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      name: {
        type: 'text'
      },
      budgetingMethod: {
        type: 'keyword'
      },
      compositeMethod: {
        type: 'keyword'
      },
      sources: {
        properties: {
          id: {
            type: 'keyword'
          },
          revision: {
            type: 'integer'
          }
        }
      },
      tags: {
        type: 'keyword'
      }
    }
  },
  management: {
    displayName: 'Composite SLO',
    importableAndExportable: true,
    getTitle(compositeSloSavedObject) {
      return `Composite SLO: [${compositeSloSavedObject.attributes.name}]`;
    }
  }
};
exports.compositeSlo = compositeSlo;