"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsRulesTypeAlertDefinition = void 0;
exports.thresholdRuleType = thresholdRuleType;
var _configSchema = require("@kbn/config-schema");
var _common = require("@kbn/data-plugin/common");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _server = require("@kbn/rule-registry-plugin/server");
var _common2 = require("../../../../common");
var _types = require("../../../../common/threshold_rule/types");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../common/constants");
var _messages = require("./messages");
var _utils = require("./utils");
var _threshold_executor = require("./threshold_executor");
var _constants3 = require("../../../../common/threshold_rule/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsRulesTypeAlertDefinition = {
  context: _constants2.THRESHOLD_RULE_REGISTRATION_CONTEXT,
  mappings: {
    fieldMap: _alertsAsDataUtils.legacyExperimentalFieldMap
  },
  useEcs: true,
  useLegacyAlerts: false
};
exports.MetricsRulesTypeAlertDefinition = MetricsRulesTypeAlertDefinition;
function thresholdRuleType(createLifecycleRuleExecutor, basePath, config, logger, ruleDataClient) {
  const baseCriterion = {
    threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
    comparator: (0, _utils.oneOfLiterals)(Object.values(_types.Comparator)),
    timeUnit: _configSchema.schema.string(),
    timeSize: _configSchema.schema.number(),
    warningComparator: _configSchema.schema.maybe((0, _utils.oneOfLiterals)(Object.values(_types.Comparator)))
  };
  const nonCountCriterion = _configSchema.schema.object({
    ...baseCriterion,
    metric: _configSchema.schema.string(),
    aggType: (0, _utils.oneOfLiterals)(_constants3.METRIC_EXPLORER_AGGREGATIONS),
    customMetrics: _configSchema.schema.never(),
    equation: _configSchema.schema.never(),
    label: _configSchema.schema.never()
  });
  const countCriterion = _configSchema.schema.object({
    ...baseCriterion,
    aggType: _configSchema.schema.literal('count'),
    metric: _configSchema.schema.never(),
    customMetrics: _configSchema.schema.never(),
    equation: _configSchema.schema.never(),
    label: _configSchema.schema.never()
  });
  const customCriterion = _configSchema.schema.object({
    ...baseCriterion,
    aggType: _configSchema.schema.literal('custom'),
    metric: _configSchema.schema.never(),
    customMetrics: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
      name: _configSchema.schema.string(),
      aggType: (0, _utils.oneOfLiterals)(['avg', 'sum', 'max', 'min', 'cardinality']),
      field: _configSchema.schema.string(),
      filter: _configSchema.schema.never()
    }), _configSchema.schema.object({
      name: _configSchema.schema.string(),
      aggType: _configSchema.schema.literal('count'),
      filter: _configSchema.schema.maybe(_configSchema.schema.string()),
      field: _configSchema.schema.never()
    })])),
    equation: _configSchema.schema.maybe(_configSchema.schema.string()),
    label: _configSchema.schema.maybe(_configSchema.schema.string())
  });
  const getSummarizedAlerts = (0, _server.createGetSummarizedAlertsFn)({
    ruleDataClient,
    useNamespace: false,
    isLifecycleAlert: false
  });
  const groupActionVariableDescription = _i18n.i18n.translate('xpack.observability.threshold.rule.alerting.groupActionVariableDescription', {
    defaultMessage: 'Name of the group(s) reporting data. For accessing each group key, use context.groupByKeys.'
  });
  return {
    id: _constants.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.observability.threshold.ruleName', {
      defaultMessage: 'Threshold (Technical Preview)'
    }),
    validate: {
      params: _configSchema.schema.object({
        criteria: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([countCriterion, nonCountCriterion, customCriterion])),
        groupBy: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])),
        filterQuery: _configSchema.schema.maybe(_configSchema.schema.string({
          validate: _utils.validateIsStringElasticsearchJSONFilter
        })),
        alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        alertOnGroupDisappear: _configSchema.schema.maybe(_configSchema.schema.boolean())
      }, {
        unknowns: 'allow'
      })
    },
    defaultActionGroupId: _threshold_executor.FIRED_ACTIONS.id,
    actionGroups: [_threshold_executor.FIRED_ACTIONS, _threshold_executor.NO_DATA_ACTIONS],
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: createLifecycleRuleExecutor((0, _threshold_executor.createMetricThresholdExecutor)({
      basePath,
      logger,
      config
    })),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'group',
        description: groupActionVariableDescription
      }, {
        name: 'groupByKeys',
        description: _messages.groupByKeysActionVariableDescription
      }, ...((0, _utils.getAlertDetailsPageEnabledForApp)(config.unsafe.alertDetails, 'metrics') ? [{
        name: 'alertDetailsUrl',
        description: _messages.alertDetailUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }] : []), {
        name: 'alertState',
        description: _messages.alertStateActionVariableDescription
      }, {
        name: 'reason',
        description: _messages.reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: _messages.timestampActionVariableDescription
      }, {
        name: 'value',
        description: _messages.valueActionVariableDescription
      }, {
        name: 'metric',
        description: _messages.metricActionVariableDescription
      }, {
        name: 'threshold',
        description: _messages.thresholdActionVariableDescription
      }, {
        name: 'cloud',
        description: _messages.cloudActionVariableDescription
      }, {
        name: 'host',
        description: _messages.hostActionVariableDescription
      }, {
        name: 'container',
        description: _messages.containerActionVariableDescription
      }, {
        name: 'orchestrator',
        description: _messages.orchestratorActionVariableDescription
      }, {
        name: 'labels',
        description: _messages.labelsActionVariableDescription
      }, {
        name: 'tags',
        description: _messages.tagsActionVariableDescription
      }, {
        name: 'originalAlertState',
        description: _messages.originalAlertStateActionVariableDescription
      }, {
        name: 'originalAlertStateWasALERT',
        description: _messages.originalAlertStateWasActionVariableDescription
      }, {
        name: 'originalAlertStateWasWARNING',
        description: _messages.originalAlertStateWasActionVariableDescription
      }, {
        name: 'originalAlertStateWasNO_DATA',
        description: _messages.originalAlertStateWasActionVariableDescription
      }]
    },
    useSavedObjectReferences: {
      // TODO revisit types https://github.com/elastic/kibana/issues/159714
      extractReferences: params => {
        const [searchConfiguration, references] = (0, _common.extractReferences)(params.searchConfiguration);
        const newParams = {
          ...params,
          searchConfiguration
        };
        return {
          params: newParams,
          references
        };
      },
      injectReferences: (params, references) => {
        return {
          ...params,
          searchConfiguration: (0, _common.injectReferences)(params.searchConfiguration, references)
        };
      }
    },
    producer: _common2.observabilityFeatureId,
    getSummarizedAlerts: getSummarizedAlerts(),
    alerts: MetricsRulesTypeAlertDefinition
  };
}