"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reasonActionVariableDescription = exports.alertDetailsUrlActionVariableDescription = void 0;
exports.sloBurnRateRuleType = sloBurnRateRuleType;
exports.viewInAppUrlActionVariableDescription = exports.timestampActionVariableDescription = exports.sloNameActionVariableDescription = exports.sloIdActionVariableDescription = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common = require("../../../../common");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _executor = require("./executor");
var _field_map = require("./field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const durationSchema = _configSchema.schema.object({
  value: _configSchema.schema.number(),
  unit: _configSchema.schema.string()
});
const windowSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  burnRateThreshold: _configSchema.schema.number(),
  maxBurnRateThreshold: _configSchema.schema.nullable(_configSchema.schema.number()),
  longWindow: durationSchema,
  shortWindow: durationSchema,
  actionGroup: _configSchema.schema.string()
});
function sloBurnRateRuleType(createLifecycleRuleExecutor, basePath, alertsLocator) {
  return {
    id: _constants2.SLO_BURN_RATE_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.observability.slo.rules.burnRate.name', {
      defaultMessage: 'SLO burn rate'
    }),
    validate: {
      params: _configSchema.schema.object({
        sloId: _configSchema.schema.string(),
        windows: _configSchema.schema.arrayOf(windowSchema)
      })
    },
    defaultActionGroupId: _constants2.ALERT_ACTION.id,
    actionGroups: [_constants2.ALERT_ACTION, _constants2.HIGH_PRIORITY_ACTION, _constants2.MEDIUM_PRIORITY_ACTION, _constants2.LOW_PRIORITY_ACTION],
    producer: _common.sloFeatureId,
    minimumLicenseRequired: 'platinum',
    isExportable: true,
    executor: createLifecycleRuleExecutor((0, _executor.getRuleExecutor)({
      basePath,
      alertsLocator
    })),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'reason',
        description: reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: timestampActionVariableDescription
      }, {
        name: 'burnRateThreshold',
        description: thresholdActionVariableDescription
      }, {
        name: 'longWindow',
        description: windowActionVariableDescription
      }, {
        name: 'shortWindow',
        description: windowActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: viewInAppUrlActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: alertDetailsUrlActionVariableDescription
      }, {
        name: 'sloId',
        description: sloIdActionVariableDescription
      }, {
        name: 'sloName',
        description: sloNameActionVariableDescription
      }]
    },
    alerts: {
      context: _constants.SLO_RULE_REGISTRATION_CONTEXT,
      mappings: {
        fieldMap: {
          ..._alertsAsDataUtils.legacyExperimentalFieldMap,
          ..._field_map.sloRuleFieldMap
        }
      },
      useEcs: false,
      useLegacyAlerts: true
    }
  };
}
const thresholdActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.thresholdDescription', {
  defaultMessage: 'The burn rate threshold value.'
});
const windowActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.windowDescription', {
  defaultMessage: 'The window duration with the associated burn rate value.'
});
const reasonActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.reasonDescription', {
  defaultMessage: 'A concise description of the reason for the alert'
});
exports.reasonActionVariableDescription = reasonActionVariableDescription;
const timestampActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.timestampDescription', {
  defaultMessage: 'A timestamp of when the alert was detected.'
});
exports.timestampActionVariableDescription = timestampActionVariableDescription;
const viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.viewInAppUrlDescription', {
  defaultMessage: 'The url to the SLO details page to help with further investigation.'
});
exports.viewInAppUrlActionVariableDescription = viewInAppUrlActionVariableDescription;
const alertDetailsUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.alertDetailsUrlDescription', {
  defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
});
exports.alertDetailsUrlActionVariableDescription = alertDetailsUrlActionVariableDescription;
const sloIdActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.sloIdDescription', {
  defaultMessage: 'The SLO unique identifier.'
});
exports.sloIdActionVariableDescription = sloIdActionVariableDescription;
const sloNameActionVariableDescription = _i18n.i18n.translate('xpack.observability.slo.alerting.sloNameDescription', {
  defaultMessage: 'The SLO name.'
});
exports.sloNameActionVariableDescription = sloNameActionVariableDescription;